% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/skewTableaux.R
\name{skewTableauxWithGivenShapeAndWeight}
\alias{skewTableauxWithGivenShapeAndWeight}
\title{Skew semistandard tableaux with given shape and weight}
\usage{
skewTableauxWithGivenShapeAndWeight(lambda, mu, weight)
}
\arguments{
\item{lambda, mu}{integer partitions defining the skew partition: 
\code{lambda} is the outer partition and \code{mu} is the inner partition 
(so \code{mu} must be a subpartition of \code{lambda})}

\item{weight}{integer vector, the weight}
}
\value{
List of all skew semistandard tableaux whose shape is the skew 
  partition defined by \code{lambda} and \code{mu} and whose weight is 
  \code{weight}.
}
\description{
Enumeration of all skew semistandard tableaux with a given 
  shape and a given weight. The \emph{weight} of a tableau is the 
  vector whose \eqn{i}-th element is the number of occurrences of \eqn{i} 
  in this tableau.
}
\examples{
ssstx <- skewTableauxWithGivenShapeAndWeight(c(3, 1, 1), c(2), c(1, 1, 1))
lapply(ssstx, prettySkewTableau)
}
