% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tAI.R
\docType{data}
\name{ecolik12}
\alias{ecolik12}
\title{E. coli K-12 codon bias and tRNA numbers}
\format{
An object of class \code{list} of length 3.
}
\usage{
ecolik12
}
\description{
A list with elements \code{trna}, a vector of length 64 of tRNA gene copy numbers 
in the Escherichia coli K-12 genome, \code{w}, a data frame with some codon bias 
statistics for 49 E. coli K-12 coding genes, and \code{m}, a 49 by 61 matrix of 
codon frequencies for the 49 genes in question.
}
\examples{
# 87 tRNA genes in the E. coli K-12 genome:
sum(ecolik12$trna)

# Two copies are isoacceptors for Phe, with anticodon GAA (codon TTC)
ecolik12$trna[2]

# ecolik12$w, a data frame with codon bias statistics
names(ecolik12$w)

# Effective number of codons vs. gene length (in codons)
plot(ecolik12$w$Nc, ecolik12$w$L_aa, xlab="Nc", ylab="Gene length")
}
\author{
Mario dos Reis
}
\keyword{datasets}
