% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tAI.R
\name{nc.f}
\alias{nc.f}
\title{Nc vs. GC3s}
\usage{
nc.f(x)
}
\arguments{
\item{x}{a vector of GC contents at third codon positions}
}
\value{
A vector of Nc values for the given GC contents.
}
\description{
Calculates the expected Nc value of a gene for a given GC content at the
third codon positions.
}
\details{
Without selection on codon bias, the expected value of Nc as a 
function of GC content at third positions, x, is given by 
\deqn{f(x) = -6 + x + 34/(x^2 + (1.025 - x)^2).} This equation
follows dos Reis et al. (2004, see also Wright 1990 for the original).
}
\examples{
curve(nc.f(x), xlab="GC3s content", ylab="Nc")
points(ecolik12$w$GC3s, ecolik12$w$Nc, pch=19)

}
\references{
Wright F. (1990) The 'effective number of codons' used in a gene. \emph{Gene}, 
\bold{87:} 23--9.

dos Reis M., Savva R., and Wernisch L. (2004) Solving the riddle of codon 
usage preferences: a test for translational selection. \emph{Nucleic Acids Res.},
\bold{32:} 5036--44.
}
\author{
Mario dos Reis
}
