% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tabreg.R
\name{tabreg}
\alias{tabreg}
\title{Create Regression Table from Betas and Standard Errors}
\usage{
tabreg(
  betas,
  ses = NULL,
  varcov = NULL,
  columns = c("beta.se", "p"),
  sep.char = ", ",
  decimals = NULL,
  formatp.list = NULL,
  labels = NULL
)
}
\arguments{
\item{betas}{Numeric vector.}

\item{ses}{Numeric vector.}

\item{varcov}{Numeric matrix.}

\item{columns}{Character vector specifying what columns to include. Choices
are \code{"beta"}, \code{"se"}, \code{"betaci"}, \code{"beta.se"},
\code{"beta.ci"}, \code{"or"}, \code{"orci"}, \code{"or.ci"}, and \code{"p"}.}

\item{sep.char}{Character string with separator to place between lower and
upper bound of confidence intervals. Typically \code{"-"} or \code{", "}.}

\item{decimals}{Numeric value specifying number of decimal places for numbers
other than p-values.}

\item{formatp.list}{List of arguments to pass to \code{\link[tab]{formatp}}.}

\item{labels}{Character vector.}
}
\value{
\code{\link[knitr]{kable}}.
}
\description{
Useful for quickly creating a summary table.
}
\examples{
# Create summary table for mtcars regression
fit <- lm(mpg ~ wt + hp + drat, data = mtcars)
tabreg(
  betas = fit$coef,
  varcov = vcov(fit),
  labels = c("Intercept", "Weight", "HP", "Rear axle ratio")
)


}
