% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/useful-items.R
\name{tablerAvatar}
\alias{tablerAvatar}
\title{Create a Boostrap 4 avatar}
\usage{
tablerAvatar(name = NULL, url = NULL, size = NULL, status = NULL, color = NULL)
}
\arguments{
\item{name}{Avatar placeholder. If not NULL, url cannot be used.}

\item{url}{Avatar image if any. If not NULL, name cannot be used.}

\item{size}{Avatar size. NULL, "sm", "md", "lg", "xl" or "xxl".}

\item{status}{Avatar status. See \url{https://preview.tabler.io/docs/colors.html}
for valid statuses.}

\item{color}{Avatar background color. See \url{https://preview.tabler.io/docs/colors.html}
for valid colors.}
}
\description{
Build a tabler avatar
}
\examples{
if(interactive()){
 library(shiny)
 library(tablerDash)

 shiny::shinyApp(
   ui = tablerDashPage(
    navbar = NULL,
    footer = NULL,
    title = "test",
    body = tablerDashBody(
     tablerAvatar(
      name = "DG",
      size = "xxl"
     ),
     tablerAvatar(
      name = "DG",
      color = "orange"
     ),
     tablerAvatar(
      name = "DG",
      status = "warning"
     ),
     tablerAvatar(url = "https://image.flaticon.com/icons/svg/145/145852.svg")
    )
   ),
   server = function(input, output) {}
 )
}

}
\author{
David Granjon, \email{dgranjon@ymail.com}
}
