% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logan.R
\name{DVR_all_ref_Logan}
\alias{DVR_all_ref_Logan}
\title{Non-invasive reference Logan method for all ROIs in tac data}
\usage{
DVR_all_ref_Logan(
  tac_data,
  ref,
  k2prime,
  t_star,
  error = 0.1,
  method = "trapz",
  ...
)
}
\arguments{
\item{tac_data}{The time-activity curve data from tac_roi()}

\item{ref}{Required -- The reference region, e.g. "cerebellum"}

\item{k2prime}{Required -- A fixed value for k2' must be specified (e.g. 0.2)}

\item{t_star}{Required -- If 0, t* will be calculated using find_t_star()}

\item{error}{For find_t_star()}

\item{method}{Method of integration, "trapz" or "integrate"}

\item{...}{When called from tm_batch, unused parameters may be supplied}
}
\value{
Data frame with calculated DVRs for all ROIs
}
\description{
This calculates the DVR using the non-invasive reference Logan method for
all TACs in a supplied tac file. It uses DVR_ref_Logan.
}
\examples{
f <- system.file("extdata", "AD06.tac", package="tacmagic")
fv <- system.file("extdata", "AD06_TAC.voistat", package="tacmagic")
AD06_tac <- load_tac(f, format="PMOD")
AD06_volume <- load_vol(fv, format="voistat")
AD06 <- tac_roi(tac=AD06_tac, volumes=AD06_volume, ROI_def=roi_ham_pib(),  
                merge=FALSE, PVC=FALSE)  

AD06_DVR <- DVR_all_ref_Logan(AD06, ref="cerebellum", k2prime=0.2, t_star=23)

}
\references{
Logan, J., Fowler, J. S., Volkow, N. D., Wang, G.-J., 
Ding, Y.-S., & Alexoff, D. L. (1996). Distribution Volume Ratios without 
Blood Sampling from Graphical Analysis of PET Data. Journal of Cerebral 
Blood Flow & Metabolism, 16(5), 834-840. 
https://doi.org/10.1097/00004647-199609000-00008
}
\seealso{
Other Logan plot functions: 
\code{\link{DVR_ref_Logan}()},
\code{\link{dvr}()},
\code{\link{plot.ref_Logan}()}
}
\concept{Logan plot functions}
