% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/decz.R
\name{decz}
\alias{decz}
\title{Decimate sampling rate recursively.}
\usage{
decz(x, df = NULL, Z = NULL, nf = 12, frbw = 0.8)
}
\arguments{
\item{x}{A vector, matrix, or tag data list containing the signal(s) to be decimated. If x is a matrix, each column is decimated separately. If inputs \code{df} and \code{Z} are both provided, then the value of \code{df} stored in \code{Z} will override the user-provided \code{df}.}

\item{df}{The decimation factor. The output sampling rate is the input sampling rate divided by df. df must be an integer greater than 1. df can also be a three element vector in which case: df(1) is the decimation factor; df(2) is the number of output samples spanned by the filter (default value is 12). A larger value makes the filter steeper; df(3) is the fractional bandwidth of the filter (default value is 0.8) relative to the output Nyquist frequency. If df(2) is greater than 12, df(3) can be closer to 1.}

\item{Z}{The 'state' list that is generated by a previous call to decz. This is how the function keeps track of filter internal values (i.e., memory) from call-to-call.}

\item{nf}{The number of output samples spanned by the filter (default value is 12). A larger value makes the filter steeper.}

\item{frbw}{The fractional bandwidth of the filter (default value is 0.8) relative to the output Nyquist frequency. If \code{nf} is greater than 12, \code{frbw} can be closer to 1.}
}
\value{
A list with elements:
\itemize{
  \item{\strong{y: }} The decimated signal vector or matrix. It has the same number of columns as x but has, on average, 1/df of the rows.
  \item{\strong{Z: }} The state list (for internal tracking of filter internal values). Contains elements df (the decimation factor), nf (used to compute the filter length), frbw (the bandwidth of the filter relative to the new Nyquist frequency), h (the FIR filter coefficients), n (the filter length), z (padded signal used for filtering), and ov ("overflow" samples to be passed to future iterations).
}
}
\description{
Recursive sampling rate decimator. This function can be run iteratively over a long data set, e.g., to decimate an entire recording that is too large to be read into memory.
}
\details{
The first time decz is called, use the following format: y = decz(x,df). The subsequent calls to decz for contiguous input data are: decz(x,Z). The final call when there is no more input data is: decz(x = NULL, Z = Z). Each output y in the above contains a segment of the decimated signal and so these need to be concatenated.
Decimation is performed in the same way as for \code{\link{decdc}}. The group delay of the filter is removed. For large decimation factors (e.g., df much greater than 50), it is better to perform several nested decimations with lower factors.
}
\examples{
plott_base(list(Accel = beaked_whale$A)) # acceleration data before decimation
a_rows <- nrow(beaked_whale$A$data)
a_ind <- data.frame(start = c(1, floor(a_rows / 3), floor(2 * a_rows / 3)))
a_ind$end <- c(a_ind$start[2:3] - 1, a_rows)
df <- 10
Z <- NULL
y <- NULL
for (k in 1:nrow(a_ind)) {
  decz_out <- decz(
    x = beaked_whale$A$data[c(a_ind[k, 1]:a_ind[k, 2]), ],
    df = df, Z = Z
  )
  df <- NULL
  Z <- decz_out$Z
  y <- rbind(y, decz_out$y)
}

}
\seealso{
\code{\link{decdc}}
}
