% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transform-nejm.R
\name{summarize_nejm_vert}
\alias{summarize_nejm_vert}
\title{Create a summarization for a categorical row versus X numerical column}
\usage{
summarize_nejm_vert(
  table,
  row,
  column,
  cell_style,
  collapse_single = TRUE,
  pformat = NULL,
  msd = FALSE,
  test = FALSE,
  quant = c(0.25, 0.5, 0.75),
  ...
)
}
\arguments{
\item{table}{The table object to modify}

\item{row}{The row variable object to use (categorical)}

\item{column}{The column variable to use (numerical)}

\item{cell_style}{list; cell styling functions}

\item{collapse_single}{logical; default TRUE. Categorical variables with a two values collapse to single row.}

\item{pformat}{numeric, character or function; A formatting directive to be applied to p-values}

\item{msd}{logical; include msd in summary}

\item{test}{logical; include statistical test results}

\item{quant}{numeric; vector of quantiles to include. Should be an odd number since the middle value is highlighted on display.}

\item{...}{absorbs additional arugments. Unused at present.}
}
\value{
The modified table object
}
\description{
Given a row and column object from the parser apply a Kruskal test and output
the results vertically (#Categories+1) X (N, Summary, Statistic)
}
