% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tar_map2_count.R, R/tar_map2_count_raw.R
\name{tar_map2_count}
\alias{tar_map2_count}
\alias{tar_map2_count_raw}
\title{Dynamic-within-static branching for data frames
(count batching).}
\usage{
tar_map2_count(
  name,
  command1,
  command2,
  values = NULL,
  names = NULL,
  descriptions = tidyselect::everything(),
  batches = 1L,
  combine = TRUE,
  suffix1 = "1",
  suffix2 = "2",
  columns1 = tidyselect::everything(),
  columns2 = tidyselect::everything(),
  rep_workers = 1,
  delimiter = "_",
  unlist = FALSE,
  tidy_eval = targets::tar_option_get("tidy_eval"),
  packages = targets::tar_option_get("packages"),
  library = targets::tar_option_get("library"),
  format = targets::tar_option_get("format"),
  repository = targets::tar_option_get("repository"),
  error = targets::tar_option_get("error"),
  memory = targets::tar_option_get("memory"),
  garbage_collection = targets::tar_option_get("garbage_collection"),
  deployment = targets::tar_option_get("deployment"),
  priority = targets::tar_option_get("priority"),
  resources = targets::tar_option_get("resources"),
  storage = targets::tar_option_get("storage"),
  retrieval = targets::tar_option_get("retrieval"),
  cue = targets::tar_option_get("cue"),
  description = targets::tar_option_get("description")
)

tar_map2_count_raw(
  name,
  command1,
  command2,
  values = NULL,
  names = NULL,
  descriptions = quote(tidyselect::everything()),
  batches = 1L,
  combine = TRUE,
  suffix1 = "1",
  suffix2 = "2",
  columns1 = quote(tidyselect::everything()),
  columns2 = quote(tidyselect::everything()),
  rep_workers = 1,
  delimiter = "_",
  unlist = FALSE,
  tidy_eval = targets::tar_option_get("tidy_eval"),
  packages = targets::tar_option_get("packages"),
  library = targets::tar_option_get("library"),
  format = targets::tar_option_get("format"),
  repository = targets::tar_option_get("repository"),
  error = targets::tar_option_get("error"),
  memory = targets::tar_option_get("memory"),
  garbage_collection = targets::tar_option_get("garbage_collection"),
  deployment = targets::tar_option_get("deployment"),
  priority = targets::tar_option_get("priority"),
  resources = targets::tar_option_get("resources"),
  storage = targets::tar_option_get("storage"),
  retrieval = targets::tar_option_get("retrieval"),
  cue = targets::tar_option_get("cue"),
  description = targets::tar_option_get("description")
)
}
\arguments{
\item{name}{Name of the target.
\code{\link[=tar_rep]{tar_rep()}} expects unevaluated \code{name} and \code{command} arguments
(e.g. \code{tar_rep(name = sim, command = simulate())})
whereas \code{\link[=tar_rep_raw]{tar_rep_raw()}} expects an evaluated string for \code{name}
and an evaluated expression object for \code{command}
(e.g. \code{tar_rep_raw(name = "sim", command = quote(simulate()))}).}

\item{command1}{R code to create named arguments to \code{command2}.
Must return a data frame with one row per call to \code{command2} when run.

In regular \code{tarchetypes} functions,
the \code{command1} argument is an unevaluated expression.
In the \code{"_raw"} versions
of functions, \code{command1} is an evaluated expression object.}

\item{command2}{R code to map over the data frame of arguments
produced by \code{command1}. Must return a data frame.

In regular \code{tarchetypes} functions,
the \code{command2} argument is an unevaluated expression.
In the \code{"_raw"} versions
of functions, \code{command2} is an evaluated expression object.}

\item{values}{Named list or data frame with values to iterate over.
The names are the names of symbols in the commands and pattern
statements, and the elements are values that get substituted
in place of those symbols. \code{\link[=tar_map]{tar_map()}} uses these elements
to create new R code, so they should be basic types, symbols,
or R expressions. For objects even a little bit complicated,
especially objects with attributes, it is not obvious how to
convert the object into code that generates it.
For complicated objects, consider using \code{quote()} when
you define \code{values}, as shown at
\url{https://github.com/ropensci/tarchetypes/discussions/105}.}

\item{names}{Subset of \code{names(values)}
used to generate the suffixes in the names of the new targets.
The value of \code{names} should be a \code{tidyselect} expression
such as a call to \code{\link[=any_of]{any_of()}} or \code{\link[=starts_with]{starts_with()}}.}

\item{descriptions}{Names of a column in \code{values}
to append to the custom description of each generated target.
The value of \code{descriptions} should be a \code{tidyselect} expression
such as a call to \code{\link[=any_of]{any_of()}} or \code{\link[=starts_with]{starts_with()}}.}

\item{batches}{Positive integer of length 1,
maximum number of batches (dynamic branches within static branches)
of the downstream (\code{command2}) targets. Batches
are formed from row groups of the \code{command1} target output.}

\item{combine}{Logical of length 1, whether to create additional downstream
targets to combine the results of static branches.
The \code{values} argument must not be \code{NULL}
for this combining to take effect.
If \code{combine} is \code{TRUE} and \code{values} is not \code{NULL},
then separate targets aggregate all dynamic branches within each
static branch, and then a final target combines all
the static branches together.}

\item{suffix1}{Character of length 1,
suffix to apply to the \code{command1} targets to distinguish
them from the \code{command2} targets.}

\item{suffix2}{Character of length 1,
suffix to apply to the \code{command2} targets to distinguish
them from the \code{command1} targets.}

\item{columns1}{A tidyselect expression to select which columns of \code{values}
to append to the output of all targets.
Columns already in the target output are not appended.

In regular \code{tarchetypes} functions,
the \code{columns1} argument is an unevaluated expression.
In the \code{"_raw"} versions
of functions, \code{columns1} is an evaluated expression object.}

\item{columns2}{A tidyselect expression to select which columns of
\code{command1}
output to append to \code{command2} output.
Columns already in the target output are not appended.
\code{columns1} takes precedence over \code{columns2}.

In regular \code{tarchetypes} functions,
the \code{columns2} argument is an unevaluated expression.
In the \code{"_raw"} versions
of functions, \code{columns2} is an evaluated expression object.}

\item{rep_workers}{Positive integer of length 1, number of local R
processes to use to run reps within batches in parallel. If 1,
then reps are run sequentially within each batch. If greater than 1,
then reps within batch are run in parallel using a PSOCK cluster.}

\item{delimiter}{Character of length 1, string to insert between
other strings when creating names of targets.}

\item{unlist}{Logical, whether to flatten the returned list of targets.
If \code{unlist = FALSE}, the list is nested and sub-lists
are named and grouped by the original input targets.
If \code{unlist = TRUE}, the return value is a flat list of targets
named by the new target names.}

\item{tidy_eval}{Whether to invoke tidy evaluation
(e.g. the \verb{!!} operator from \code{rlang}) as soon as the target is defined
(before \code{tar_make()}). Applies to the \code{command} argument.}

\item{packages}{Character vector of packages to load right before
the target runs or the output data is reloaded for
downstream targets. Use \code{tar_option_set()} to set packages
globally for all subsequent targets you define.}

\item{library}{Character vector of library paths to try
when loading \code{packages}.}

\item{format}{Optional storage format for the target's return value.
With the exception of \code{format = "file"}, each target
gets a file in \verb{_targets/objects}, and each format is a different
way to save and load this file. See the "Storage formats" section
for a detailed list of possible data storage formats.}

\item{repository}{Character of length 1, remote repository for target
storage. Choices:
\itemize{
\item \code{"local"}: file system of the local machine.
\item \code{"aws"}: Amazon Web Services (AWS) S3 bucket. Can be configured
with a non-AWS S3 bucket using the \code{endpoint} argument of
\code{\link[targets:tar_resources_aws]{tar_resources_aws()}}, but versioning capabilities may be lost
in doing so.
See the cloud storage section of
\url{https://books.ropensci.org/targets/data.html}
for details for instructions.
\item \code{"gcp"}: Google Cloud Platform storage bucket.
See the cloud storage section of
\url{https://books.ropensci.org/targets/data.html}
for details for instructions.
\item A character string from \code{\link[targets:tar_repository_cas]{tar_repository_cas()}} for content-addressable
storage.
}

Note: if \code{repository} is not \code{"local"} and \code{format} is \code{"file"}
then the target should create a single output file.
That output file is uploaded to the cloud and tracked for changes
where it exists in the cloud. As of \code{targets} version 1.11.0 and higher,
the local file is no longer deleted after the target runs.}

\item{error}{Character of length 1, what to do if the target
stops and throws an error. Options:
\itemize{
\item \code{"stop"}: the whole pipeline stops and throws an error.
\item \code{"continue"}: the whole pipeline keeps going.
\item \code{"null"}: The errored target continues and returns \code{NULL}.
The data hash is deliberately wrong so the target is not
up to date for the next run of the pipeline. In addition,
as of \code{targets} version 1.8.0.9011, a value of \code{NULL} is given
to upstream dependencies with \code{error = "null"} if loading fails.
\item \code{"abridge"}: any currently running targets keep running,
but no new targets launch after that.
\item \code{"trim"}: all currently running targets stay running. A queued
target is allowed to start if:
\enumerate{
\item It is not downstream of the error, and
\item It is not a sibling branch from the same \code{\link[targets:tar_target]{tar_target()}} call
(if the error happened in a dynamic branch).
}

The idea is to avoid starting any new work that the immediate error
impacts. \code{error = "trim"} is just like \code{error = "abridge"},
but it allows potentially healthy regions of the dependency graph
to begin running.
(Visit \url{https://books.ropensci.org/targets/debugging.html}
to learn how to debug targets using saved workspaces.)
}}

\item{memory}{Character of length 1, memory strategy. Possible values:
\itemize{
\item \code{"auto"} (default): equivalent to \code{memory = "transient"} in almost
all cases. But to avoid superfluous reads from disk,
\code{memory = "auto"} is equivalent to \code{memory = "persistent"} for
for non-dynamically-branched targets that other targets
dynamically branch over. For example: if your pipeline has
\code{tar_target(name = y, command = x, pattern = map(x))},
then \code{tar_target(name = x, command = f(), memory = "auto")}
will use persistent memory for \code{x}
in order to avoid rereading all of \code{x}
for every branch of \code{y}.
\item \code{"transient"}: the target gets unloaded
after every new target completes.
Either way, the target gets automatically loaded into memory
whenever another target needs the value.
\item \code{"persistent"}: the target stays in memory
until the end of the pipeline (unless \code{storage} is \code{"worker"},
in which case \code{targets} unloads the value from memory
right after storing it in order to avoid sending
copious data over a network).
}

For cloud-based file targets
(e.g. \code{format = "file"} with \code{repository = "aws"}),
the \code{memory} option applies to the
temporary local copy of the file:
\code{"persistent"} means it remains until the end of the pipeline
and is then deleted,
and \code{"transient"} means it gets deleted as soon as possible.
The former conserves bandwidth,
and the latter conserves local storage.}

\item{garbage_collection}{Logical: \code{TRUE} to run \code{base::gc()}
just before the target runs, in whatever R process it is about to run
(which could be a parallel worker).
\code{FALSE} to omit garbage collection.
Numeric values get converted to \code{FALSE}.
The \code{garbage_collection} option in \code{\link[targets:tar_option_set]{tar_option_set()}}
is independent of the
argument of the same name in \code{\link[targets:tar_target]{tar_target()}}.}

\item{deployment}{Character of length 1. If \code{deployment} is
\code{"main"}, then the target will run on the central controlling R process.
Otherwise, if \code{deployment} is \code{"worker"} and you set up the pipeline
with distributed/parallel computing, then
the target runs on a parallel worker. For more on distributed/parallel
computing in \code{targets}, please visit
\url{https://books.ropensci.org/targets/crew.html}.}

\item{priority}{Deprecated on 2025-04-08 (\code{targets} version 1.10.1.9013).
\code{targets} has moved to a more efficient scheduling algorithm
(\url{https://github.com/ropensci/targets/issues/1458})
which cannot support priorities.
The \code{priority} argument of \code{\link[targets:tar_target]{tar_target()}} no longer has a reliable
effect on execution order.}

\item{resources}{Object returned by \code{tar_resources()}
with optional settings for high-performance computing
functionality, alternative data storage formats,
and other optional capabilities of \code{targets}.
See \code{tar_resources()} for details.}

\item{storage}{Character string to control when the output of the target
is saved to storage. Only relevant when using \code{targets}
with parallel workers (\url{https://books.ropensci.org/targets/crew.html}).
Must be one of the following values:
\itemize{
\item \code{"worker"} (default): the worker saves/uploads the value.
\item \code{"main"}: the target's return value is sent back to the
host machine and saved/uploaded locally.
\item \code{"none"}: \code{targets} makes no attempt to save the result
of the target to storage in the location where \code{targets}
expects it to be. Saving to storage is the responsibility
of the user. Use with caution.
}}

\item{retrieval}{Character string to control when the current target
loads its dependencies into memory before running.
(Here, a "dependency" is another target upstream that the current one
depends on.) Only relevant when using \code{targets}
with parallel workers (\url{https://books.ropensci.org/targets/crew.html}).
Must be one of the following values:
\itemize{
\item \code{"auto"} (default): equivalent to \code{retrieval = "worker"} in almost all
cases. But to avoid unnecessary reads from disk, \code{retrieval = "auto"}
is equivalent to \code{retrieval = "main"} for dynamic branches that
branch over non-dynamic targets. For example: if your pipeline has
\code{tar_target(x, command = f())}, then
\code{tar_target(y, command = x, pattern = map(x), retrieval = "auto")}
will use \code{"main"} retrieval in order to avoid rereading all of \code{x}
for every branch of \code{y}.
\item \code{"worker"}: the worker loads the target's dependencies.
\item \code{"main"}: the target's dependencies are loaded on the host machine
and sent to the worker before the target runs.
\item \code{"none"}: \code{targets} makes no attempt to load its
dependencies. With \code{retrieval = "none"}, loading dependencies
is the responsibility of the user. Use with caution.
}}

\item{cue}{An optional object from \code{tar_cue()} to customize the
rules that decide whether the target is up to date.}

\item{description}{Character of length 1, a custom free-form human-readable
text description of the target. Descriptions appear as target labels
in functions like \code{\link[targets:tar_manifest]{tar_manifest()}} and \code{\link[targets:tar_visnetwork]{tar_visnetwork()}},
and they let you select subsets of targets for the \code{names} argument of
functions like \code{\link[targets:tar_make]{tar_make()}}. For example,
\code{tar_manifest(names = tar_described_as(starts_with("survival model")))}
lists all the targets whose descriptions start with the character
string \code{"survival model"}.}
}
\value{
A list of new target objects.
See the "Target objects" section for background.
}
\description{
Define targets for batched
dynamic-within-static branching for data frames,
where the user sets the (maximum) number of batches.

\code{\link[=tar_map2_count]{tar_map2_count()}} expects unevaluated language for arguments
\code{name}, \code{command1}, \code{command2}, \code{columns1}, and \code{columns2}.
\code{\link[=tar_map2_count_raw]{tar_map2_count_raw()}} expects a character string for \code{name}
and an evaluated expression object  for each of
\code{command1}, \code{command2}, \code{columns1}, and \code{columns2}.
}
\details{
Static branching creates one pair of targets
for each row in \code{values}. In each pair,
there is an upstream non-dynamic target that runs \code{command1}
and a downstream dynamic target that runs \code{command2}.
\code{command1} produces a data frame of arguments to
\code{command2}, and \code{command2} dynamically maps over
these arguments in batches.
}
\section{Target objects}{

Most \code{tarchetypes} functions are target factories,
which means they return target objects
or lists of target objects.
Target objects represent skippable steps of the analysis pipeline
as described at \url{https://books.ropensci.org/targets/}.
Please read the walkthrough at
\url{https://books.ropensci.org/targets/walkthrough.html}
to understand the role of target objects in analysis pipelines.

For developers,
\url{https://wlandau.github.io/targetopia/contributing.html#target-factories}
explains target factories (functions like this one which generate targets)
and the design specification at
\url{https://books.ropensci.org/targets-design/}
details the structure and composition of target objects.
}

\section{Replicate-specific seeds}{

In ordinary pipelines, each target has its own unique deterministic
pseudo-random number generator seed derived from its target name.
In batched replicate, however, each batch is a target with multiple
replicate within that batch. That is why \code{\link[=tar_rep]{tar_rep()}}
and friends give each \emph{replicate} its own unique seed.
Each replicate-specific seed is created
based on the dynamic parent target name,
\code{tar_option_get("seed")} (for \code{targets} version 0.13.5.9000 and above),
batch index, and rep-within-batch index.
The seed is set just before the replicate runs.
Replicate-specific seeds are invariant to batching structure.
In other words,
\code{tar_rep(name = x, command = rnorm(1), batches = 100, reps = 1, ...)}
produces the same numerical output as
\code{tar_rep(name = x, command = rnorm(1), batches = 10, reps = 10, ...)}
(but with different batch names).
Other target factories with this seed scheme are \code{\link[=tar_rep2]{tar_rep2()}},
\code{\link[=tar_map_rep]{tar_map_rep()}}, \code{\link[=tar_map2_count]{tar_map2_count()}}, \code{\link[=tar_map2_size]{tar_map2_size()}},
and \code{\link[=tar_render_rep]{tar_render_rep()}}.
For the \verb{tar_map2_*()} functions,
it is possible to manually supply your own seeds
through the \code{command1} argument and then invoke them in your
custom code for \code{command2} (\code{set.seed()}, \code{withr::with_seed},
or \code{withr::local_seed()}). For \code{\link[=tar_render_rep]{tar_render_rep()}},
custom seeds can be supplied to the \code{params} argument
and then invoked in the individual R Markdown reports.
Likewise with \code{\link[=tar_quarto_rep]{tar_quarto_rep()}} and the \code{execute_params} argument.
}

\examples{
if (identical(Sys.getenv("TAR_LONG_EXAMPLES"), "true")) {
targets::tar_dir({ # tar_dir() runs code from a temporary directory.
targets::tar_script({
  tarchetypes::tar_map2_count(
    x,
    command1 = tibble::tibble(
      arg1 = arg1,
      arg2 = seq_len(6)
     ),
    command2 = tibble::tibble(
      result = paste(arg1, arg2),
      random = sample.int(1e9, size = 1),
      length_input = length(arg1)
    ),
    values = tibble::tibble(arg1 = letters[seq_len(2)]),
    batches = 3
   )
})
targets::tar_make()
targets::tar_read(x)
# With tar_map2_count_raw():
targets::tar_script({
  tarchetypes::tar_map2_count_raw(
    name = "x",
    command1 = quote(
      tibble::tibble(
        arg1 = arg1,
        arg2 = seq_len(6)
      )
    ),
    command2 = quote(
      tibble::tibble(
        result = paste(arg1, arg2),
        random = sample.int(1e9, size = 1),
        length_input = length(arg1)
      )
    ),
    values = tibble::tibble(arg1 = letters[seq_len(2)]),
    batches = 3
   )
})
})
}
}
\seealso{
Other branching: 
\code{\link{tar_map2}()},
\code{\link{tar_map2_size}()},
\code{\link{tar_map_rep}()},
\code{\link{tar_rep}()},
\code{\link{tar_rep2}()},
\code{\link{tar_rep_map}()},
\code{\link{tar_rep_map_raw}()}
}
\concept{branching}
