% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/syn2taxo.R
\name{syn2taxo}
\alias{syn2taxo}
\title{Synonym list to taxolist}
\usage{
syn2taxo(
  synlist,
  canonical = "canonical",
  synonym = "synonym",
  verbose = FALSE
)
}
\arguments{
\item{synlist}{Synonym list with Accepted name (canonical) and Synonym columns}

\item{canonical}{Accepted names column name, Default: 'canonical'}

\item{synonym}{Synonym column name , Default: 'synonym'}

\item{verbose}{verbose output on the console}
}
\value{
returns a data frame in taxolist format with all the names in 
 canonical column and accepted names linked to synonyms using id and accid
 fields. Order, family and (guessed) taxonlevel are added if missing. Genus,
 species and subspecies fields are added by melting the canonical names.
}
\description{
Converts a Synonym list with Accepted Names and Synonym columns
 to taxolist format
}
\details{
Converts a synonyms list to taxolist format. If order and family
 fields are present, then they are carried forward else NAs are populated.
 Duplicate synomyms with same source are removed but with different sources 
 are retained.
}
\examples{
\donttest{
 synlist <- data.frame("id" = c(1,2,3),
                       "canonical" = c("Hypochlorosis ancharia",
                                       "Hypochlorosis ancharia",
                                       "Hypochlorosis ancharia"),
                       "synonym" = c( "Hypochlorosis tenebrosa",
                                      "Pseudonotis humboldti",
                                      "Myrina ancharia"),
                       "family" = c("Lycaenidae", "Lycaenidae", 
                                    "Lycaenidae"),
                       "source" = c("itis","wiki","wiki"),
                       stringsAsFactors = FALSE)
                       
 mytaxo <- syn2taxo(synlist)
}
}
\seealso{
Other List functions: 
\code{\link{DwC2taxo}()},
\code{\link{cast_cs_field}()},
\code{\link{compact_ids}()},
\code{\link{get_synonyms}()},
\code{\link{match_lists}()},
\code{\link{melt_cs_field}()},
\code{\link{merge_lists}()},
\code{\link{synonymize_subspecies}()},
\code{\link{taxo2DwC}()},
\code{\link{taxo2doc}()},
\code{\link{taxo2syn}()},
\code{\link{wiki2taxo}()}
}
\concept{List functions}
