% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{predict.pkmod}
\alias{predict.pkmod}
\title{Predict method for pkmod objects}
\usage{
\method{predict}{pkmod}(object, inf, tms, return_times = FALSE, ...)
}
\arguments{
\item{object}{An object with class pkmod.}

\item{inf}{A matrix with columns "begin","end","inf_rate" indicating when infusions should
be administered. Can be created by `inf_manual` or `inf_tci`.}

\item{tms}{Times at which to calculate predicted concentrations.}

\item{return_times}{Logical. Should prediction times be returned along with responses? Defaults to FALSE.}

\item{...}{List or vector of values to be passed on to update.pkmod.}
}
\value{
Matrix of predicted concentrations associated with a pkmod object and
and infusion schedule.
}
\description{
Predict concentrations from a pkmod object - can be a user defined function
}
\examples{
# dosing schedule
dose <- inf_manual(inf_tms = c(0,0.5,4,4.5,10), inf_rate = c(100,0,80,0,0))
# pkmod object
my_mod <- pkmod(pars_pk = c(CL = 15, V1 = 10, Q2 = 10, V2 = 20))
# predict at specific times
predict(my_mod, inf = dose, tms = c(1.5,2.5,3))
# predict with an Emax PD function
my_mod_pd <- pkmod(pars_pk = c(v1 = 8.995, v2 = 17.297, v3 = 120.963, cl = 1.382,
q2 = 0.919, q3 = 0.609, ke0 = 1.289),
pars_pd = c(c50 = 2.8, gamma = 1.47, gamma2 = 1.89, e0 = 93, emx = 93),
pdfn = emax, pdinv = emax_inv, ecmpt = 4)
predict(my_mod_pd, inf = dose, tms = c(1.5,2.5,3))
# predict with a subset of new PK-PD parameters
predict(my_mod_pd, inf = dose, tms = c(1.5,2.5,3), pars_pk = c(ke0 = 0.8),
pars_pd = c(c50 = 2, e0 = 100))
}
