% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tleaves.R
\name{.get_re}
\alias{.get_re}
\title{Re: Reynolds number}
\usage{
.get_re(T_leaf, pars, unitless)
}
\arguments{
\item{T_leaf}{Leaf temperature in Kelvin}

\item{pars}{Concatenated parameters (\code{leaf_par}, \code{enviro_par}, and \code{constants})}

\item{unitless}{Logical. Should function use parameters with \code{units}? The function is faster when FALSE, but input must be in correct units or else results will be incorrect without any warning.}
}
\value{
A unitless number of class \code{units}
}
\description{
Re: Reynolds number
}
\details{
\deqn{Re = u d / D_\mathrm{m}}{Re = u d / D_m}

\tabular{lllll}{
\emph{Symbol} \tab \emph{R} \tab \emph{Description} \tab \emph{Units} \tab \emph{Default}\cr
\eqn{d} \tab \code{leafsize} \tab Leaf characteristic dimension in meters \tab m \tab 0.1\cr
\eqn{D_\mathrm{m}}{D_m} \tab \code{D_m} \tab diffusion coefficient of momentum in air \tab m\eqn{^2} / s \tab \link[=.get_Dx]{calculated}\cr
\eqn{u} \tab \code{wind} \tab windspeed \tab m / s \tab 2
}
}
\examples{

library(tealeaves)

cs <- make_constants()
ep <- make_enviropar()
lp <- make_leafpar()

T_leaf <- set_units(298.15, K)

tealeaves:::.get_re(T_leaf, c(cs, ep, lp), FALSE)

}
