% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trigonometry_degrees.R
\name{dist_greatcircle}
\alias{dist_greatcircle}
\title{Distance between points}
\usage{
dist_greatcircle(
  lat1,
  lon1,
  lat2,
  lon2,
  r = earth_radius(),
  method = c("haversine", "orthodrome", "vincenty", "euclidean")
)
}
\arguments{
\item{lat1, lon1}{numeric vector. coordinate of point(s) 1 (degrees).}

\item{lat2, lon2}{numeric vector. coordinates of point(s) 2 (degrees).}

\item{r}{numeric. radius of the sphere (default = 6371.0087714 km, i.e. the
radius of the Earth)}

\item{method}{Character. Formula for calculating great circle distance,
one of:
\describe{
\item{\code{"haversine"}}{great circle distance based on the haversine
formula that is optimized for 64-bit floating-point numbers (the default)}
\item{\code{"orthodrome"}}{great circle distance based on the spherical law of cosines}
\item{\code{"vincenty"}}{distance based on the Vincenty formula for an
ellipsoid with equal major and minor axes}
\item{"euclidean"}{Euclidean distance (not great circle distance!)}
}}
}
\value{
numeric vector with length equal to \code{length(lat1)}
}
\description{
Returns the great circle distance between a location and all grid point in km
}
\examples{
dist_greatcircle(lat1 = 20, lon1 = 12, lat2 = c(50, 30), lon2 = c(40, 32))
dist_greatcircle(
  lat1 = 20, lon1 = 12, lat2 = c(50, 30), lon2 = c(40, 32),
  method = "orthodrome"
)
dist_greatcircle(
  lat1 = 20, lon1 = 12, lat2 = c(50, 30), lon2 = c(40, 32),
  method = "vincenty"
)
dist_greatcircle(
  lat1 = 20, lon1 = 12, lat2 = c(50, 30), lon2 = c(40, 32),
  method = "euclidean"
)
}
\seealso{
\code{\link[=orthodrome]{orthodrome()}}, \code{\link[=haversine]{haversine()}}, \code{\link[=vincenty]{vincenty()}}
}
