% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_rSSR.R
\name{rSSR_plot}
\alias{rSSR_plot}
\title{Plot the rSSR Curve and Convergence Thresholds and Optimum MBP}
\usage{
rSSR_plot(rSSR_df, opt_mbp_df, var_groups = NULL)
}
\arguments{
\item{rSSR_df}{a dataframe created by created by renorm_SSRduration compare
showing the renormalized sum of squares of the residuals between one
potential blanking period and the next.}

\item{opt_mbp_df}{a dataframe created by opt_mbp showing the values for the
convergence thresholds and optimum mbps}

\item{var_groups}{a single string or vector of strings of the columns which
should be used to group organisms. Common groupings are species and cohorts.}
}
\value{
A plot of the rSSR curve, convergence thresholds, and optimum mbps
}
\description{
Using the dataframes produced by renorm_SSR and opt_mbp, plots the rSSR
curve, and all the convergence thresholds (horizontal lines) and
corresponding optimum mbps (vertical lines).
}
\examples{
#plot the rSSR and log(rSSR) curves
rSSR_plot(rSSR_df = ex_rSSR,
          opt_mbp_df = ex_opt,
          var_groups = "fish_type")
}
