% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tabulate_gee.R
\name{tabulate_gee}
\alias{tabulate_gee}
\alias{as.rtable.tern_gee}
\alias{s_lsmeans_logistic}
\alias{a_lsmeans_logistic}
\alias{summarize_gee_logistic}
\title{Tabulation of a GEE Model}
\usage{
\method{as.rtable}{tern_gee}(x, type = c("coef", "cov"), ...)

s_lsmeans_logistic(df, .in_ref_col)

a_lsmeans_logistic(df, .in_ref_col)

summarize_gee_logistic(
  lyt,
  ...,
  table_names = "lsmeans_logistic_summary",
  .stats = NULL,
  .formats = NULL,
  .indent_mods = NULL,
  .labels = NULL
)
}
\arguments{
\item{x}{(\code{data.frame})\cr the object which should be converted to an \code{rtable}.}

\item{type}{(\code{character})\cr type of table to extract from \code{tern_gee} object.}

\item{...}{additional arguments for methods.}

\item{df}{(\code{data.frame})\cr data set resulting from \code{\link[=lsmeans]{lsmeans()}}.}

\item{.in_ref_col}{(\code{logical})\cr \code{TRUE} when working with the reference level, \code{FALSE} otherwise.}

\item{lyt}{(\code{layout})\cr input layout where analyses will be added to.}

\item{table_names}{(\code{character})\cr this can be customized in case that the same \code{vars}
are analyzed multiple times, to avoid warnings from \code{rtables}.}

\item{.stats}{(\code{character})\cr statistics to select for the table.}

\item{.formats}{(named \code{character} or \code{list})\cr formats for the statistics.}

\item{.indent_mods}{(named \code{integer})\cr indent modifiers for the labels.}

\item{.labels}{(named \code{character})\cr labels for the statistics (without indent).}
}
\value{
The functions have different purposes:
\itemize{
\item \code{as.rtable()} returns either the coefficient table or the covariance matrix as an
\code{rtables} object.
\item \code{s_lsmeans_logistic()} returns several least square mean statistics from the GEE.
\item \code{a_lsmeans_logistic()} is the formatted analysis function and returns the formatted statistics.
\item \code{summarize_gee_logistic()} is the analyze function and returns the modified \code{rtables} layout.
}
}
\description{
Functions to produce tables from a fitted GEE produced with \code{\link[=fit_gee]{fit_gee()}}.
}
\section{Functions}{
\itemize{
\item \code{as.rtable(tern_gee)}: Extracts the coefficient table or covariance matrix estimate from a \code{tern_gee} object.

\item \code{s_lsmeans_logistic()}: Statistics function which extracts estimates from a
\code{\link[=lsmeans]{lsmeans()}} data frame based on a logistic GEE model.

\item \code{a_lsmeans_logistic()}: Formatted Analysis function which can be further customized by calling
\code{\link[rtables:make_afun]{rtables::make_afun()}} on it. It is used as \code{afun} in \code{\link[rtables:analyze]{rtables::analyze()}}.

\item \code{summarize_gee_logistic()}: Analyze function for tabulating least-squares means estimates
from logistic GEE least square mean results.

}}
\examples{
library(dplyr)

df <- fev_data \%>\%
  mutate(AVAL = as.integer(fev_data$FEV1 > 30))
df_counts <- df \%>\%
  select(USUBJID, ARMCD) \%>\%
  unique()

lsmeans_df <- lsmeans(fit_gee(vars = vars_gee(arm = "ARMCD"), data = df))

s_lsmeans_logistic(lsmeans_df[1, ], .in_ref_col = TRUE)

s_lsmeans_logistic(lsmeans_df[2, ], .in_ref_col = FALSE)
basic_table() \%>\%
  split_cols_by("ARMCD") \%>\%
  add_colcounts() \%>\%
  summarize_gee_logistic(
    .in_ref_col = FALSE
  ) \%>\%
  build_table(lsmeans_df, alt_counts_df = df_counts)
}
