% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formatting_functions.R
\name{extreme_format}
\alias{extreme_format}
\alias{h_get_format_threshold}
\alias{h_format_threshold}
\title{Format extreme values}
\usage{
h_get_format_threshold(digits = 2L)

h_format_threshold(x, digits = 2L)
}
\arguments{
\item{digits}{(\code{integer(1)})\cr number of decimal places to display.}

\item{x}{(\code{numeric(1)})\cr value to format.}
}
\value{
\itemize{
\item \code{h_get_format_threshold()} returns a \code{list} of 2 elements: \code{threshold}, with \code{low} and \code{high} thresholds,
and \code{format_string}, with thresholds formatted as strings.
}

\itemize{
\item \code{h_format_threshold()} returns the given value, or if the value is not within the digit threshold the relation
of the given value to the digit threshold, as a formatted string.
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

\code{rtables} formatting functions that handle extreme values.
}
\details{
For each input, apply a format to the specified number of \code{digits}. If the value is
below a threshold, it returns "<0.01" e.g. if the number of \code{digits} is 2. If the value is
above a threshold, it returns ">999.99" e.g. if the number of \code{digits} is 2.
If it is zero, then returns "0.00".
}
\section{Functions}{
\itemize{
\item \code{h_get_format_threshold()}: Internal helper function to calculate the threshold and create formatted strings
used in Formatting Functions. Returns a list with elements \code{threshold} and \code{format_string}.

\item \code{h_format_threshold()}: Internal helper function to apply a threshold format to a value.
Creates a formatted string to be used in Formatting Functions.

}}
\examples{
h_get_format_threshold(2L)

h_format_threshold(0.001)
h_format_threshold(1000)

}
\seealso{
Other formatting functions: 
\code{\link{format_auto}()},
\code{\link{format_count_fraction}()},
\code{\link{format_count_fraction_fixed_dp}()},
\code{\link{format_count_fraction_lt10}()},
\code{\link{format_extreme_values}()},
\code{\link{format_extreme_values_ci}()},
\code{\link{format_fraction}()},
\code{\link{format_fraction_fixed_dp}()},
\code{\link{format_fraction_threshold}()},
\code{\link{format_sigfig}()},
\code{\link{format_xx}()},
\code{\link{formatting_functions}}
}
\concept{formatting functions}
