% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_tiles.R
\name{get_tiles}
\alias{get_tiles}
\alias{get_tiles.sf}
\alias{get_tiles.sfc}
\alias{get_tiles.Raster}
\alias{get_tiles.SpatRaster}
\alias{get_tiles.list}
\title{A user-friendly way to get USGS National Map data tiles for an area}
\usage{
get_tiles(
  data,
  output_prefix = tempfile(),
  side_length = NULL,
  resolution = 1,
  services = "elevation",
  verbose = FALSE,
  georeference = TRUE,
  projected = NULL,
  ...
)

\method{get_tiles}{sf}(
  data,
  output_prefix = tempfile(),
  side_length = NULL,
  resolution = 1,
  services = "elevation",
  verbose = FALSE,
  georeference = TRUE,
  projected = NULL,
  ...
)

\method{get_tiles}{sfc}(
  data,
  output_prefix = tempfile(),
  side_length = NULL,
  resolution = 1,
  services = "elevation",
  verbose = FALSE,
  georeference = TRUE,
  projected = NULL,
  ...
)

\method{get_tiles}{Raster}(
  data,
  output_prefix = tempfile(),
  side_length = NULL,
  resolution = 1,
  services = "elevation",
  verbose = FALSE,
  georeference = TRUE,
  projected = NULL,
  ...
)

\method{get_tiles}{SpatRaster}(
  data,
  output_prefix = tempfile(),
  side_length = NULL,
  resolution = 1,
  services = "elevation",
  verbose = FALSE,
  georeference = TRUE,
  projected = NULL,
  ...
)

\method{get_tiles}{list}(
  data,
  output_prefix = tempfile(),
  side_length = NULL,
  resolution = 1,
  services = "elevation",
  verbose = FALSE,
  georeference = TRUE,
  projected = NULL,
  ...
)
}
\arguments{
\item{data}{An \code{sf} or \code{SpatRaster} object; tiles will be downloaded for the
full extent of the provided object.}

\item{output_prefix}{The file prefix to use when saving tiles.}

\item{side_length}{The length, in meters, of each side of tiles to download.
If \code{NULL}, defaults to the maximum side length permitted by the least
permissive service requested.}

\item{resolution}{How many meters are represented by each pixel? The default
value of 1 means that 1 pixel = 1 meter, while a value of 2 means that
1 pixel = 2 meters, and so on.}

\item{services}{A character vector of services to download data from. Current
options include "3DEPElevation", "USGSNAIPPlus", and "nhd". Users can also
use short codes to download a specific type of data without specifying the
source; current options for short codes include "elevation" (equivalent to
"3DEPElevation"), "ortho" (equivalent to "USGSNAIPPlus), and "hydro" ("nhd").
Short codes are
not guaranteed to refer to the same source across releases. Short codes are
converted to their service name and then duplicates are removed, so any given
source will only be queried once per tile.}

\item{verbose}{Logical: should tile retrieval functions run in verbose mode?}

\item{georeference}{Logical: should tiles be downloaded as PNGs without
georeferencing, or should they be downloaded as georeferenced TIFF files?
This option does nothing when only elevation data is being downloaded.}

\item{projected}{Logical: is \code{data} in a projected coordinate reference
system? If \code{NULL}, the default, inferred from \link[sf:st_is_longlat]{sf::st_is_longlat}.}

\item{...}{Additional arguments passed to \link{hit_national_map_api}.
These can be used to change default query parameters or as additional options
for the National Map services. See below for more details.}
}
\value{
A list of the same length as the number of unique services requested,
containing named vectors of where data files were saved to. Returned
invisibly.
}
\description{
This function splits the area contained within a bounding box into a set of
tiles, and retrieves data from the USGS National map for each tile. As of
version 0.5.0, the method for lists has been deprecated.
}
\section{Available Datasources}{

The following services are currently available
(with short codes in parentheses where applicable). See links for API
documentation.
\itemize{
\item \href{https://elevation.nationalmap.gov/arcgis/rest/services/3DEPElevation/ImageServer}{3DEPElevation}
(short code: elevation)
\item \href{https://imagery.nationalmap.gov/arcgis/rest/services/USGSNAIPPlus/ImageServer/exportImage}{USGSNAIPPlus}
(short code: ortho)
\item \href{https://imagery.nationalmap.gov/arcgis/rest/services/USGSNAIPImagery/ImageServer}{USGSNAIPImagery}
\item \href{https://hydro.nationalmap.gov/arcgis/rest/services/nhd/MapServer}{nhd}
(short code: hydro)
\item \href{https://carto.nationalmap.gov/arcgis/rest/services/govunits/MapServer}{govunits}
\item \href{https://carto.nationalmap.gov/arcgis/rest/services/contours/MapServer}{contours}
\item \href{https://carto.nationalmap.gov/arcgis/rest/services/geonames/MapServer}{geonames}
\item \href{https://hydro.nationalmap.gov/arcgis/rest/services/NHDPlus_HR/MapServer}{NHDPlus_HR}
\item \href{https://carto.nationalmap.gov/arcgis/rest/services/structures/MapServer}{structures}
\item \href{https://carto.nationalmap.gov/arcgis/rest/services/transportation/MapServer}{transportation}
\item \href{https://hydro.nationalmap.gov/arcgis/rest/services/wbd/MapServer}{wbd}
("short code": watersheds)
\item \href{https://www.usgs.gov/centers/geosciences-and-environmental-change-science-center/science/global-ecosystems}{ecosystems}
\item \href{https://basemap.nationalmap.gov/arcgis/rest/services/USGSTopo/MapServer}{USGSTopo}
\item \href{https://basemap.nationalmap.gov/arcgis/rest/services/USGSShadedReliefOnly/MapServer}{USGSShadedReliefOnly}
\item \href{https://basemap.nationalmap.gov/arcgis/rest/services/USGSImageryOnly/MapServer}{USGSImageryOnly}
\item \href{https://basemap.nationalmap.gov/arcgis/rest/services/USGSHydroCached/MapServer}{USGSHydroCached}
}
}

\section{Additional Arguments}{

The \code{...} argument can be used to pass additional arguments to the
National Map API or to edit the hard-coded defaults used by this function.
More information on common arguments to change can be found in
\link{hit_national_map_api}. Note that \code{...} can also be used to change
the formats returned by the server, but that doing so while using this
function will likely cause the function to error (or corrupt the output
data). To download files in different formats, use \link{hit_national_map_api}.
}

\examples{
\dontrun{
simulated_data <- data.frame(
  id = seq(1, 100, 1),
  lat = runif(100, 44.04905, 44.17609),
  lng = runif(100, -74.01188, -73.83493)
)

simulated_data <- sf::st_as_sf(simulated_data, coords = c("lng", "lat"))

get_tiles(simulated_data, tempfile())
}

}
\seealso{
Other data retrieval functions: 
\code{\link{hit_national_map_api}()}
}
\concept{data retrieval functions}
