% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/textBoxPlacement.R
\name{positionTextBoxDriver}
\alias{positionTextBoxDriver}
\title{positionTextBoxDriver}
\usage{
positionTextBoxDriver(
  text,
  x,
  y,
  xPos,
  nApprox = 10,
  xList,
  yList,
  stag = FALSE,
  offset = 0,
  verbose
)
}
\arguments{
\item{text}{character string text to insert in plot}

\item{x}{numeric vector of x values}

\item{y}{numeric vector of y values}

\item{xPos}{numeric x position for text box}

\item{nApprox}{integer number of intervals to interpolate between x data points}

\item{xList}{list whose components are numeric vectors of the x values for overlaid curves}

\item{yList}{list whose components are numeric vectors of the y values for overlaid curves}

\item{stag}{Boolean TRUE if this plot has staggering added to curves}

\item{offset}{numeric vector of offsets added to each curve}

\item{verbose}{Boolean if TRUE print informative or diagnostic messages to console}
}
\value{
returns a numeric vector c(yReal,yAdj) where xTry is an x value at which the text box will fit
without overlapping another overlay curve, or returns -1000000 for failure
}
\description{
Driver to compute x and y coordinates for placement of text box
based upon the values of the function
to avoid running into the graph line
and avoid overlapping with other overlay curves
}
\examples{
positionTextBoxDriver(text="TEXT ME",x=xList1[[1]],y=yList1[[1]],
  xPos=1,nApprox=10,xList=xList1[-1],yList=yList1[-1],stag=FALSE,offset=0,verbose=TRUE)

}
