% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/text.table.R
\name{str_count_nomatch}
\alias{str_count_nomatch}
\title{Count the words in a vector that are not found in another vector.}
\usage{
str_count_nomatch(x, y, ratio = FALSE)
}
\arguments{
\item{x}{A vector of words.}

\item{y}{A vector of words to test against.}

\item{ratio}{TRUE/FALSE, if TRUE, returns the number of words in x without a match in y divided by the number of words in x.}
}
\value{
A number, the count of words in x and not in y
}
\description{
Count the words in a vector that are not found in another vector.
}
\examples{
str_count_nomatch(
x = c("a", "dog", "went", "to", "the", "store"),
y = c("dog", "to", "store")
)
str_count_nomatch(
x = c("a", "dog", "went", "to", "the", "store"),
y = c("dog", "store"),
ratio = TRUE
)
}
