% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/text.table.R
\name{str_rm_words_by_length}
\alias{str_rm_words_by_length}
\title{Remove words from a vector based on the number of characters in each word.}
\usage{
str_rm_words_by_length(x, min_char_length = 0, max_char_length = Inf)
}
\arguments{
\item{x}{A vector of words.}

\item{min_char_length, }{An integer, the minimum number of characters a word can have to not be removed.}

\item{max_char_length, }{An integer, the maximum number of characters a word can have to not be removed.}
}
\value{
x, with the words not having a character count of at least the min_char_length and at most the max_char_length removed.
}
\description{
Remove words from a vector based on the number of characters in each word.
}
\examples{
str_rm_words_by_length(
x = c("a", "dog", "went", "to", "the", "store"),
min_char_length = 3
)
}
