% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/topic_modeling_core.R
\name{predict.lsa_topic_model}
\alias{predict.lsa_topic_model}
\title{Predict method for LSA topic models}
\usage{
\method{predict}{lsa_topic_model}(object, newdata, ...)
}
\arguments{
\item{object}{a fitted object of class "lsa_topic_model"}

\item{newdata}{a DTM or TCM of class dgCMatrix or a numeric vector}

\item{...}{further arguments passed to or from other methods.}
}
\value{
a "theta" matrix with one row per document and one column per topic
}
\description{
Obtains predictions of topics for new documents from a fitted LSA model
}
\examples{
# Load a pre-formatted dtm 
data(nih_sample_dtm) 

# Convert raw word counts to TF-IDF frequency weights
idf <- log(nrow(nih_sample_dtm) / Matrix::colSums(nih_sample_dtm > 0))

dtm_tfidf <- Matrix::t(nih_sample_dtm) * idf

dtm_tfidf <- Matrix::t(dtm_tfidf)

# Fit an LSA model on the first 50 documents
model <- FitLsaModel(dtm = dtm_tfidf[1:50,], k = 5)

# Get predictions on the next 50 documents
pred <- predict(model, dtm_tfidf[51:100,])
}
