% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/web_search.R
\name{web_search}
\alias{web_search}
\title{Process search results from multiple search engines}
\usage{
web_search(
  search_term,
  search_engine,
  num_pages = 1,
  time_filter = NULL,
  insite = NULL,
  intitle = FALSE
)
}
\arguments{
\item{search_term}{The search query as a string.}

\item{search_engine}{The search engine to use: "DuckDuckGo", "Bing", or "Yahoo News".}

\item{num_pages}{The number of result pages to retrieve (default: 1).}

\item{time_filter}{Optional time filter ("week", "month", "year").}

\item{insite}{Restrict search to a specific domain (not supported for Yahoo).}

\item{intitle}{Search within the title (relevant for DuckDuckGo and Bing).}
}
\value{
A `data.table` containing search engine results with columns `search_engine` and `raw_url`.
}
\description{
This function allows you to query different search engines (DuckDuckGo, Bing, Yahoo News),
retrieve search results, and filter them based on predefined patterns.
}
