% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optimizers_.R
\name{lookahead_mechanism}
\alias{lookahead_mechanism}
\title{Lookahead mechanism}
\usage{
lookahead_mechanism(
  optimizer,
  sync_period = 6,
  slow_step_size = 0.5,
  name = "Lookahead",
  clipnorm = NULL,
  clipvalue = NULL,
  decay = NULL,
  lr = NULL
)
}
\arguments{
\item{optimizer}{The original optimizer that will be used to compute and apply the gradients.}

\item{sync_period}{An integer. The synchronization period of lookahead. Enable lookahead mechanism
by setting it with a positive value.}

\item{slow_step_size}{A floating point value. The ratio for updating the slow weights.}

\item{name}{Optional name for the operations created when applying gradients. Defaults to "Lookahead".}

\item{clipnorm}{is clip gradients by norm.}

\item{clipvalue}{is clip gradients by value.}

\item{decay}{is included for backward compatibility to allow time inverse decay of learning rate.}

\item{lr}{is included for backward compatibility, recommended to use learning_rate instead.}
}
\value{
Optimizer for use with `keras::compile()`
}
\description{
Lookahead mechanism
}
\details{
The mechanism is proposed by Michael R. Zhang et.al in the paper
[Lookahead Optimizer: k steps forward, 1 step back](https://arxiv.org/abs/1907.08610v1).
The optimizer iteratively updates two sets of weights: the search directions for weights
are chosen by the inner optimizer, while the "slow weights" are updated each k steps based
on the directions of the "fast weights" and the two sets of weights are synchronized.
This method improves the learning stability and lowers the variance of its inner optimizer.
}
\examples{

\dontrun{

opt = tf$keras$optimizers$SGD(learning_rate)
opt = lookahead_mechanism(opt)

}
}
