% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stsm.R, R/ucarima.R, R/um.R
\name{autocov.ssm}
\alias{autocov.ssm}
\alias{autocov.ucarima}
\alias{autocov}
\alias{autocov.um}
\title{Theoretical autocovariances of an ARMA model}
\usage{
\method{autocov}{ssm}(mdl, lag.max = NULL, arma = TRUE, varphi = FALSE, tol = 1e-04, ...)

\method{autocov}{ucarima}(mdl, ma = FALSE, ...)

autocov(mdl, ...)

\method{autocov}{um}(mdl, lag.max = 10, ...)
}
\arguments{
\item{mdl}{an object of class \code{um} or \code{ucm}.}

\item{lag.max}{maximum lag for autocovariances.}

\item{arma}{logical. If TRUE, the autocovariances for the stationary ARMA
model of the reduced form are computed. Otherwise, the autocovariances are
only computed for the MA part.}

\item{varphi}{logical. If TRUE, the varphi polynomial of the reduced form is
also returned.}

\item{tol}{tolerance to check if a root is close to one.}

\item{...}{additional arguments.}

\item{ma}{logical; if true, autocovariances are computed for the MA model. By
default, ma = FALSE and autocovariances are computed for the ARMA model.}
}
\value{
A numeric vector.
}
\description{
\code{autocov} computes the autocovariances of an ARMA model.
}
\note{
The I polynomial is ignored.
}
\examples{
# Local level model
ssm1 <- ssm(b = 1, C = 1, S = diag(c(irr = 0.8, lvl = 0.04)))
autocov(ssm1)

ar1 <- um(ar = "1-0.8B")
autocov(ar1, lag.max = 13)

}
