% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcmc-kernels.R
\name{mcmc_replica_exchange_mc}
\alias{mcmc_replica_exchange_mc}
\title{Runs one step of the Replica Exchange Monte Carlo}
\usage{
mcmc_replica_exchange_mc(
  target_log_prob_fn,
  inverse_temperatures,
  make_kernel_fn,
  swap_proposal_fn = tfp$mcmc$replica_exchange_mc$default_swap_proposal_fn(1),
  state_includes_replicas = FALSE,
  seed = NULL,
  name = NULL
)
}
\arguments{
\item{target_log_prob_fn}{Function which takes an argument like
\code{current_state} (if it's a list \code{current_state} will be unpacked) and returns its
(possibly unnormalized) log-density under the target distribution.}

\item{inverse_temperatures}{\verb{1D} Tensor of inverse temperatures to perform
samplings with each replica. Must have statically known \code{shape}.
\code{inverse_temperatures[0]} produces the states returned by samplers,
and is typically == 1.}

\item{make_kernel_fn}{Function which takes target_log_prob_fn and seed
args and returns a TransitionKernel instance.}

\item{swap_proposal_fn}{function which take a number of replicas, and
return combinations of replicas for exchange.}

\item{state_includes_replicas}{Boolean indicating whether the leftmost dimension
of each state sample should index replicas. If \code{TRUE}, the leftmost
dimension of the \code{current_state} kwarg to \code{tfp.mcmc.sample_chain} will
be interpreted as indexing replicas.}

\item{seed}{integer to seed the random number generator.}

\item{name}{string prefixed to Ops created by this function.
Default value: \code{NULL} (i.e., "remc_kernel").}
}
\value{
list of
\code{next_state} (Tensor or Python list of \code{Tensor}s representing the state(s)
of the Markov chain(s) at each result step. Has same shape as
and \code{current_state}.) and
\code{kernel_results} (\code{collections$namedtuple} of internal calculations used to
'advance the chain).
}
\description{
\href{https://en.wikipedia.org/wiki/Parallel_tempering}{Replica Exchange Monte Carlo}
is a Markov chain Monte Carlo (MCMC) algorithm that is also known as Parallel Tempering.
This algorithm performs multiple sampling with different temperatures in parallel,
and exchanges those samplings according to the Metropolis-Hastings criterion.
The \code{K} replicas are parameterized in terms of \code{inverse_temperature}'s,
\verb{(beta[0], beta[1], ..., beta[K-1])}.  If the target distribution has
probability density \code{p(x)}, the \code{kth} replica has density \code{p(x)**beta_k}.
}
\details{
Typically \code{beta[0] = 1.0}, and \verb{1.0 > beta[1] > beta[2] > ... > 0.0}.
\itemize{
\item \code{beta[0] == 1} ==> First replicas samples from the target density, \code{p}.
\item \code{beta[k] < 1}, for \verb{k = 1, ..., K-1} ==> Other replicas sample from
"flattened" versions of \code{p} (peak is less high, valley less low).  These
distributions are somewhat closer to a uniform on the support of \code{p}.
Samples from adjacent replicas \code{i}, \code{i + 1} are used as proposals for each
other in a Metropolis step.  This allows the lower \code{beta} samples, which
explore less dense areas of \code{p}, to occasionally be used to help the
\code{beta == 1} chain explore new regions of the support.
Samples from replica 0 are returned, and the others are discarded.
}
}
\seealso{
Other mcmc_kernels: 
\code{\link{mcmc_dual_averaging_step_size_adaptation}()},
\code{\link{mcmc_hamiltonian_monte_carlo}()},
\code{\link{mcmc_metropolis_adjusted_langevin_algorithm}()},
\code{\link{mcmc_metropolis_hastings}()},
\code{\link{mcmc_no_u_turn_sampler}()},
\code{\link{mcmc_random_walk_metropolis}()},
\code{\link{mcmc_simple_step_size_adaptation}()},
\code{\link{mcmc_slice_sampler}()},
\code{\link{mcmc_transformed_transition_kernel}()},
\code{\link{mcmc_uncalibrated_hamiltonian_monte_carlo}()},
\code{\link{mcmc_uncalibrated_langevin}()},
\code{\link{mcmc_uncalibrated_random_walk}()}
}
\concept{mcmc_kernels}
