% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bijectors.R
\name{tfb_transpose}
\alias{tfb_transpose}
\title{Computes\code{Y = g(X) = transpose_rightmost_dims(X, rightmost_perm)}}
\usage{
tfb_transpose(
  perm = NULL,
  rightmost_transposed_ndims = NULL,
  validate_args = FALSE,
  name = "transpose"
)
}
\arguments{
\item{perm}{Positive integer vector-shaped Tensor representing permutation of
rightmost dims (for forward transformation).  Note that the 0th index
represents the first of the rightmost dims and the largest value must be
rightmost_transposed_ndims - 1 and corresponds to \code{tf$rank(x) - 1}.
Only one of perm and rightmost_transposed_ndims can (and must) be specified.
Default value: \code{tf$range(start=rightmost_transposed_ndims, limit=-1, delta=-1)}.}

\item{rightmost_transposed_ndims}{Positive integer scalar-shaped Tensor
representing the number of rightmost dimensions to permute.
Only one of perm and rightmost_transposed_ndims can (and must) be
specified. Default value: \code{tf$size(perm)}.}

\item{validate_args}{Logical, default FALSE. Whether to validate input with asserts. If validate_args is
FALSE, and the inputs are invalid, correct behavior is not guaranteed.}

\item{name}{name prefixed to Ops created by this class.}
}
\value{
a bijector instance.
}
\description{
This bijector is semantically similar to tf.transpose except that it
transposes only the rightmost "event" dimensions. That is, unlike
\code{tf$transpose} the perm argument is itself a permutation of
\code{tf$range(rightmost_transposed_ndims)} rather than \code{tf$range(tf$rank(x))},
i.e., users specify the (rightmost) dimensions to permute, not all dimensions.
}
\details{
The actual (forward) transformation is:

\code{sample_batch_ndims <- tf$rank(x) - tf$size(perm)
perm = tf$concat(list(tf$range(sample_batch_ndims), sample_batch_ndims + perm),axis=0)
tf$transpose(x, perm)}
}
\seealso{
For usage examples see \code{\link[=tfb_forward]{tfb_forward()}}, \code{\link[=tfb_inverse]{tfb_inverse()}}, \code{\link[=tfb_inverse_log_det_jacobian]{tfb_inverse_log_det_jacobian()}}.

Other bijectors: 
\code{\link{tfb_absolute_value}()},
\code{\link{tfb_affine}()},
\code{\link{tfb_affine_linear_operator}()},
\code{\link{tfb_affine_scalar}()},
\code{\link{tfb_ascending}()},
\code{\link{tfb_batch_normalization}()},
\code{\link{tfb_blockwise}()},
\code{\link{tfb_chain}()},
\code{\link{tfb_cholesky_outer_product}()},
\code{\link{tfb_cholesky_to_inv_cholesky}()},
\code{\link{tfb_correlation_cholesky}()},
\code{\link{tfb_cumsum}()},
\code{\link{tfb_discrete_cosine_transform}()},
\code{\link{tfb_exp}()},
\code{\link{tfb_expm1}()},
\code{\link{tfb_ffjord}()},
\code{\link{tfb_fill_scale_tri_l}()},
\code{\link{tfb_fill_triangular}()},
\code{\link{tfb_glow}()},
\code{\link{tfb_gompertz_cdf}()},
\code{\link{tfb_gumbel}()},
\code{\link{tfb_gumbel_cdf}()},
\code{\link{tfb_identity}()},
\code{\link{tfb_inline}()},
\code{\link{tfb_invert}()},
\code{\link{tfb_iterated_sigmoid_centered}()},
\code{\link{tfb_kumaraswamy}()},
\code{\link{tfb_kumaraswamy_cdf}()},
\code{\link{tfb_lambert_w_tail}()},
\code{\link{tfb_masked_autoregressive_default_template}()},
\code{\link{tfb_masked_autoregressive_flow}()},
\code{\link{tfb_masked_dense}()},
\code{\link{tfb_matrix_inverse_tri_l}()},
\code{\link{tfb_matvec_lu}()},
\code{\link{tfb_normal_cdf}()},
\code{\link{tfb_ordered}()},
\code{\link{tfb_pad}()},
\code{\link{tfb_permute}()},
\code{\link{tfb_power_transform}()},
\code{\link{tfb_rational_quadratic_spline}()},
\code{\link{tfb_rayleigh_cdf}()},
\code{\link{tfb_real_nvp}()},
\code{\link{tfb_real_nvp_default_template}()},
\code{\link{tfb_reciprocal}()},
\code{\link{tfb_reshape}()},
\code{\link{tfb_scale}()},
\code{\link{tfb_scale_matvec_diag}()},
\code{\link{tfb_scale_matvec_linear_operator}()},
\code{\link{tfb_scale_matvec_lu}()},
\code{\link{tfb_scale_matvec_tri_l}()},
\code{\link{tfb_scale_tri_l}()},
\code{\link{tfb_shift}()},
\code{\link{tfb_shifted_gompertz_cdf}()},
\code{\link{tfb_sigmoid}()},
\code{\link{tfb_sinh}()},
\code{\link{tfb_sinh_arcsinh}()},
\code{\link{tfb_softmax_centered}()},
\code{\link{tfb_softplus}()},
\code{\link{tfb_softsign}()},
\code{\link{tfb_split}()},
\code{\link{tfb_square}()},
\code{\link{tfb_tanh}()},
\code{\link{tfb_transform_diagonal}()},
\code{\link{tfb_weibull}()},
\code{\link{tfb_weibull_cdf}()}
}
\concept{bijectors}
