% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse-open-api.R
\name{parse_openapi_spec}
\alias{parse_openapi_spec}
\alias{parse_openapi_schema}
\title{Parse an OpenAPI spec}
\usage{
parse_openapi_spec(file)

parse_openapi_schema(file)
}
\arguments{
\item{file}{Either a path to a file, a connection, or literal data (a
single string).}
}
\value{
For \code{parse_openapi_spec()} a data frame with the columns
\itemize{
\item \code{endpoint} \verb{<character>} Name of the endpoint.
\item \code{operation} \verb{<character>} The http operation; one of \code{"get"}, \code{"put"},
\code{"post"}, \code{"delete"}, \code{"options"}, \code{"head"}, \code{"patch"}, or \code{"trace"}.
\item \code{status_code} \verb{<character>} The http status code. May contain wildcards like
\verb{2xx} for all response codes between \code{200} and \code{299}.
\item \code{media_type} \verb{<character>} The media type.
\item \code{spec} \verb{<list>} A list of tibblify specifications.
}

For \code{parse_openapi_schema()} a tibblify spec.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
Use \code{parse_openapi_spec()} to parse a \href{https://swagger.io/specification/}{OpenAPI spec}
or use \code{parse_openapi_schema()} to parse a OpenAPI schema.
}
\examples{
file <- '{
  "$schema": "http://json-schema.org/draft-04/schema",
  "title": "Starship",
  "description": "A vehicle.",
  "type": "object",
  "properties": {
    "name": {
      "type": "string",
      "description": "The name of this vehicle. The common name, e.g. Sand Crawler."
    },
    "model": {
      "type": "string",
      "description": "The model or official name of this vehicle."
    },
    "url": {
      "type": "string",
      "format": "uri",
      "description": "The hypermedia URL of this resource."
    },
    "edited": {
      "type": "string",
      "format": "date-time",
      "description": "the ISO 8601 date format of the time this resource was edited."
    }
  },
  "required": [
    "name",
    "model",
    "edited"
  ]
}'

parse_openapi_schema(file)
}
