% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mx_dummies.R
\name{mx_dummies}
\alias{mx_dummies}
\title{Dummy Code Factor Variables}
\usage{
mx_dummies(x, classes = c("factor", "character"), ...)
}
\arguments{
\item{x}{An object for which a method exists.}

\item{classes}{Character vector, indicating which classes to dummy code.
Defaults to \code{c("factor", "character")}.}

\item{...}{Arguments}
}
\value{
A \code{data.frame}.
}
\description{
For each variable \emph{v} that inherits
\code{factor}, create a number of new variables equal
to \code{levels(v)} to indicate group membership (1)
or non-membership (0) of that level.
The resulting dummies have class \code{mxFactor}.
}
\examples{
if(requireNamespace("OpenMx", quietly = TRUE)){
mx_dummies(iris[1:5,])
}
}
