% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarise_draws.R
\name{summarise_draws.grouped_df}
\alias{summarise_draws.grouped_df}
\title{Summaries of draws in \code{grouped_df} objects}
\usage{
\method{summarise_draws}{grouped_df}(.x, ...)
}
\arguments{
\item{.x}{A grouped data frame (\code{dplyr::grouped_df} object) such as returned by
\code{dplyr::group_by()} where the data frame in each group (ignoring grouping columns)
has the structure of a \code{posterior::draws_df()} object: \code{".chain"}, \code{".iteration"}, and
\code{".draw"} columns, with the remaining (non-grouping) columns being draws
from variables.}

\item{...}{Name-value pairs of summary or \link[posterior:diagnostics]{diagnostic}
functions. The provided names will be used as the names of the columns in
the result \emph{unless} the function returns a named vector, in which case the
latter names are used. The functions can be specified in any format
supported by \link[rlang:as_function]{as_function()}. See \strong{Examples}.}
}
\value{
A data frame (actually, a \link[tibble:tibble]{tibble}) with all grouping
columns from \code{.x}, a \code{"variable"} column containing variable names from \code{.x},
and the remaining columns containing summary statistics and diagnostics.
}
\description{
An implementation of \code{posterior::summarise_draws()} for grouped data frames
(\code{dplyr::grouped_df} objects) such as returned by \code{dplyr::group_by()} and
the various grouped-data-aware functions in tidybayes, such as \code{spread_draws()},
\code{gather_draws()}, \code{add_epred_draws()}, and \code{add_predicted_draws()}.
This function provides a quick way to get a variety of summary statistics
and diagnostics on draws.
}
\details{
While \code{posterior::summarise_draws()} can operate on tidy data frames of
draws in the \code{posterior::draws_df()} format, that format does not support
grouping columns. This provides an implementation of \code{summarise_draws()}
that does support grouped data tables, essentially applying
\code{posterior::summarise_draws()} to every sub-table of \code{.x} implied by the
groups defined on the data frame.

See \code{posterior::summarise_draws()} for
more details on the summary statistics and diagnostics you can use with this
function. If you just want point summaries and intervals (not diagnostics),
particularly for plotting, see \code{point_interval()}, which returns long-format
data tables more suitable for that purpose (especially if you want to plot
multiple uncertainty levels).
}
\examples{

library(posterior)
library(dplyr)

d = posterior::example_draws()

# The default posterior::summarise_draws() summarises all variables without
# splitting out indices:
summarise_draws(d)

# The grouped_df implementation of summarise_draws() in tidybayes can handle
# output from spread_draws(), which is a grouped data table with the indices
# (here, `i`) left as columns:
d \%>\%
  spread_draws(theta[i]) \%>\%
  summarise_draws()

# Summary functions can also be provided, as in posterior::summarise_draws():
d \%>\%
  spread_draws(theta[i]) \%>\%
  summarise_draws(median, mad, rhat, ess_tail)

}
\seealso{
\code{\link[posterior:draws_summary]{posterior::summarise_draws()}}, \code{\link[=point_interval]{point_interval()}}
}
\author{
Matthew Kay
}
\keyword{manip}
