% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-fun_cpt.R
\name{new_fun_cpt}
\alias{new_fun_cpt}
\alias{validate_fun_cpt}
\alias{fun_cpt}
\title{Class for model-fitting functions}
\usage{
new_fun_cpt(x, ...)

validate_fun_cpt(x)

fun_cpt(x, ...)
}
\arguments{
\item{x}{a \code{character} giving the name of a model-fitting function}

\item{...}{currently ignored}
}
\value{
A \link{fun_cpt} object.
}
\description{
Class for model-fitting functions
}
\details{
All model-fitting functions must be registered through a call to \code{\link[=fun_cpt]{fun_cpt()}}.

All model-fitting functions must take at least three arguments:
\itemize{
\item \code{x}: a time series,
\item \code{tau}: a set of changepoint indices
\item \code{...}: other arguments passed to methods
}

See \code{\link[=fit_meanshift_norm]{fit_meanshift_norm()}},
}
\examples{
# Register a model-fitting function
f <- fun_cpt("fit_meanvar")

# Verify that it now has class `fun_cpt`
str(f)

# Use it
f(CET, 42)
}
\seealso{
Other model-fitting: 
\code{\link{fit_arima}()},
\code{\link{fit_lmshift}()},
\code{\link{fit_meanshift}()},
\code{\link{fit_meanvar}()},
\code{\link{fit_nhpp}()},
\code{\link{model_args}()},
\code{\link{model_name}()},
\code{\link{whomademe}()}
}
\concept{model-fitting}
