% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/column_chart_functions.R
\name{column_chart_reference}
\alias{column_chart_reference}
\title{Generate column chart with reference line.}
\usage{
column_chart_reference(
  data,
  x,
  series,
  ref_value,
  ref_label = NULL,
  styles = NULL,
  interval = "months"
)
}
\arguments{
\item{data}{data frame in wide format containing data to be plotted}

\item{x}{vector containing labels for x axis or name of column in data with values of x axis labels}

\item{series}{vector containing names of columns in data with values to plot}

\item{ref_value}{one element numeric vector with referencing value.}

\item{ref_label}{name of the referencing value}

\item{styles}{optional vector with styles of bars}

\item{interval}{intervals on x axis. The width of the bars depends on this parameter}
}
\value{
object of class tidychart with a character vector containing SVG elements
}
\description{
Generate column chart with reference line.
}
\examples{
# prepare some data frame
df <- data.frame(x = month.abb[1:6],
                 y = c(2, 4, 2, 1, 2.5, 3),
                 z = c(3, 4.5, 2, 1, 4, 2))

# generate character vector with svg data
column_chart_reference(df, x = 'x',
                       series = 'y',
                       ref_value = 3,
                       ref_label = 'baseline')

}
