% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/join_charts.R
\name{facet_chart}
\alias{facet_chart}
\title{Facet chart.}
\usage{
facet_chart(data, facet_by, ncols = 3, FUN, ...)
}
\arguments{
\item{data}{data frame in wide format containing data to be plotted}

\item{facet_by}{a name of column in data, that the charts will be splitted by}

\item{ncols}{number of columns of the plots. Number of rows will be adjusted accordingly}

\item{FUN}{function to plot the basic chart}

\item{...}{other parameters passed to FUN}
}
\value{
object of class tidychart with a character vector containing SVG elements
}
\description{
Create multiple charts with data split into groups.
}
\examples{
facet_chart(
  data = mtcars,
  facet_by = 'cyl',
  ncols = 2,
  FUN = scatter_plot,
  x = mtcars$hp,
  y = mtcars$qsec,
  legend_title = ''
 )
}
