% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pkg_load.R
\name{pkg_load}
\alias{pkg_load}
\alias{pkg_unload}
\title{Load or unload R package(s)}
\usage{
pkg_load(..., pkg_names = NULL)

pkg_unload(..., pkg_names = NULL)
}
\arguments{
\item{...}{Name(s) of package(s).}

\item{pkg_names}{(Optional)Character vector containing packages to load
or unload. Default uses \code{NULL}.}
}
\description{
This function is a wrapper for \code{\link[base]{require}} and
\code{\link[base]{detach}}.  \code{pkg_load} checks to see if a
package is installed, if not it attempts to install the package
from CRAN. \code{pkg_unload} can detach one or more loaded packages.
}
\examples{
\dontrun{
pkg_load(data.table)
pkg_unload(data.table)

pkg_load(stringr,fst)
pkg_unload(stringr,fst)

pkg_load(pkg_names = c("data.table","fst"))
p_unload(pkg_names = c("data.table","fst"))

pkg_load(data.table,stringr,fst)
pkg_unload("all") # shortcut to unload all loaded packages
}
}
\seealso{
\code{\link[base]{require}},
\code{\link[base]{detach}},
\code{\link[pacman]{p_load}},
\code{\link[pacman]{p_unload}}
}
