% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarise.R
\name{summarise}
\alias{summarise}
\alias{summarise_when}
\alias{summarise_vars}
\title{Summarise columns to single values}
\usage{
summarise(.data, ..., by = NULL)

summarise_when(.data, when, ..., by = NULL)

summarise_vars(.data, .cols = NULL, .func, ..., by)
}
\arguments{
\item{.data}{A data.table}

\item{...}{List of variables or name-value pairs of summary/modifications
functions for \code{summarise_dt}.Additional parameters to be passed to
 parameter '.func' in \code{summarise_vars}.}

\item{by}{Unquoted name of grouping variable of list of unquoted names of
grouping variables. For details see \link[data.table]{data.table}}

\item{when}{An object which can be coerced to logical mode}

\item{.cols}{Columns to be summarised.}

\item{.func}{Function to be run within each column, should return a value or vectors with same length.}
}
\value{
A data.table
}
\description{
Create one or more scalar variables summarizing
 the variables of an existing data.table.
}
\examples{

a = as.data.table(iris)
a \%>\% summarise(sum = sum(Sepal.Length),avg = mean(Sepal.Length))


a \%>\%
  summarise_when(Sepal.Length > 5, avg = mean(Sepal.Length), by = Species)

a \%>\%
  summarise_vars(is.numeric, min, by = Species)


}
