% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta_cfg.R
\name{VIMP_cfg}
\alias{VIMP_cfg}
\title{Configuration of Variable Importance}
\description{
\code{VIMP_cfg} is a configuration class for estimating a variable importance measure
across all moderators. This provides a meaningful measure of which moderators
explain the most of the CATE surface.
}
\examples{
VIMP_cfg$new()

## ------------------------------------------------
## Method `VIMP_cfg$new`
## ------------------------------------------------

VIMP_cfg$new()
}
\references{
\itemize{
\item Williamson, B. D., Gilbert, P. B., Carone, M., & Simon, N. (2021).
Nonparametric variable importance assessment using machine learning techniques.
Biometrics, 77(1), 9-22.
\item Williamson, B. D., Gilbert, P. B., Simon, N. R., & Carone, M. (2021).
A general framework for inference on algorithm-agnostic variable importance.
Journal of the American Statistical Association, 1-14.
}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{estimand}}{String indicating the estimand to target.}

\item{\code{sample_splitting}}{Logical indicating whether to use sample
splitting in the calculation of variable importance.}

\item{\code{linear}}{Logical indicating whether the variable importance
assuming a linear model should be estimated.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-VIMP_cfg-new}{\code{VIMP_cfg$new()}}
\item \href{#method-VIMP_cfg-clone}{\code{VIMP_cfg$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-VIMP_cfg-new"></a>}}
\if{latex}{\out{\hypertarget{method-VIMP_cfg-new}{}}}
\subsection{Method \code{new()}}{
Create a new \code{VIMP_cfg} object with specified model configuration.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{VIMP_cfg$new(sample_splitting = TRUE, linear_only = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{sample_splitting}}{Logical indicating whether to use sample splitting
in the calculation of variable importance. Choosing not to use sample
splitting means that inference will only be valid for moderators with
non-null importance.}

\item{\code{linear_only}}{Logical indicating whether the variable importance
should use only a single linear-only model. Variable importance measure
will only be consistent for the population quantity if the true model
of pseudo-outcomes is linear.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{VIMP_cfg} object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{VIMP_cfg$new()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-VIMP_cfg-clone"></a>}}
\if{latex}{\out{\hypertarget{method-VIMP_cfg-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{VIMP_cfg$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
