% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gt_pca_randomSVD.R
\name{gt_pca_randomSVD}
\alias{gt_pca_randomSVD}
\title{PCA for \code{gen_tibble} objects by randomized partial SVD}
\usage{
gt_pca_randomSVD(
  x,
  k = 10,
  fun_scaling = bigsnpr::snp_scaleBinom(),
  tol = 1e-04,
  verbose = FALSE,
  n_cores = 1,
  fun_prod = bigstatsr::big_prodVec,
  fun_cprod = bigstatsr::big_cprodVec,
  total_var = TRUE
)
}
\arguments{
\item{x}{a \code{gen_tibble} object}

\item{k}{Number of singular vectors/values to compute. Default is \code{10}.
\strong{This algorithm should be used to compute a few singular vectors/values.}}

\item{fun_scaling}{Usually this  can be left unset, as it defaults to
\code{\link[bigsnpr:snp_scaleBinom]{bigsnpr::snp_scaleBinom()}}, which is the appropriate function for
biallelic SNPs. Alternatively it is possible to use  custom function (see
\code{\link[bigsnpr:snp_autoSVD]{bigsnpr::snp_autoSVD()}} for details.}

\item{tol}{Precision parameter of \link[RSpectra:svds]{svds}. Default is \code{1e-4}.}

\item{verbose}{Should some progress be printed? Default is \code{FALSE}.}

\item{n_cores}{Number of cores used.}

\item{fun_prod}{Function that takes 6 arguments (in this order):
\itemize{
\item a matrix-like object \code{X},
\item a vector \code{x},
\item a vector of row indices \code{ind.row} of \code{X},
\item a vector of column indices \code{ind.col} of \code{X},
\item a vector of column centers (corresponding to \code{ind.col}),
\item a vector of column scales (corresponding to \code{ind.col}),
and compute the product of \code{X} (subsetted and scaled) with \code{x}.
}}

\item{fun_cprod}{Same as \code{fun.prod}, but for the \emph{transpose} of \code{X}.}

\item{total_var}{a boolean indicating whether to compute the total variance
of the matrix. Default is \code{TRUE}. Using \code{FALSE} will speed up computation,
but the total variance will not be stored in the output (and thus it will
not be possible to assign a proportion of variance explained to the
components).}
}
\value{
a \code{gt_pca} object, which is a subclass of \code{bigSVD}; this is
an S3 list with elements:
A named list (an S3 class "big_SVD") of
\itemize{
\item \code{d}, the eigenvalues (singular values, i.e. as variances),
\item \code{u}, the scores for each sample on each component (the left singular
vectors)
\item \code{v}, the loadings (the right singular vectors)
\item \code{center}, the centering vector,
\item \code{scale}, the scaling vector,
\item \code{method}, a string defining the method (in this case 'randomSVD'),
\item \code{call}, the call that generated the object.
}

Note: rather than accessing these elements directly, it is better to use
\code{tidy} and \code{augment}. See \code{\link{gt_pca_tidiers}}.
}
\description{
This function performs Principal Component Analysis on a \code{gen_tibble},
by randomised partial SVD based on the
algorithm in RSpectra (by Yixuan Qiu and Jiali Mei).\cr
This algorithm is linear in time in all dimensions and is very
memory-efficient. Thus, it can be used on very large big.matrices.
This function is a wrapper
for \code{\link[bigstatsr:big_randomSVD]{bigstatsr::big_randomSVD()}}
}
\examples{
\dontshow{if (all(rlang::is_installed(c("RhpcBLASctl", "data.table")))) withAutoprint(\{ # examplesIf}
\dontshow{
data.table::setDTthreads(2)
RhpcBLASctl::blas_set_num_threads(2)
RhpcBLASctl::omp_set_num_threads(2)
}
vcf_path <-
  system.file("extdata", "anolis",
    "punctatus_t70_s10_n46_filtered.recode.vcf.gz",
    package = "tidypopgen"
  )
anole_gt <-
  gen_tibble(vcf_path, quiet = TRUE, backingfile = tempfile("anolis_"))

# Remove monomorphic loci and impute
anole_gt <- anole_gt \%>\% select_loci_if(loci_maf(genotypes) > 0)
anole_gt <- gt_impute_simple(anole_gt, method = "mode")

# Create PCA object, including total variance
gt_pca_randomSVD(anole_gt, k = 10, total_var = TRUE)
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[bigstatsr:big_randomSVD]{bigstatsr::big_randomSVD()}} which this function wraps.
}
