% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rate_adj_direct.R
\name{rate_adj_direct}
\alias{rate_adj_direct}
\title{Compute direct adjusted rates with tibbles}
\usage{
rate_adj_direct(
  .data,
  .std,
  .keys = NULL,
  .name_var = "name",
  .value_var = "value",
  .age_group_var = "age_group",
  .age_group_pop_var = "population",
  .events_label = "events",
  .population_label = "population",
  .progress = TRUE
)
}
\arguments{
\item{.data}{A tibble containing events counts and population per groups (e.g. age groups)}

\item{.std}{A vector with standard population values for each group}

\item{.keys}{Optional. A character vector with grouping variables, like year and region code.}

\item{.name_var}{Variable containing variable names. Defaults to \code{name}.}

\item{.value_var}{Variable containing values. Defaults to \code{value}.}

\item{.age_group_var}{Variable name of age groups. Defaults to \code{age_group}.}

\item{.age_group_pop_var}{Variable name of population size on \code{.std}. Defaults to \code{population}.}

\item{.events_label}{Label used for events at the \code{name_var} variable. Defaults to \code{events}.}

\item{.population_label}{Label used for population at the \code{name_var} variable. Defautls to \code{population}.}

\item{.progress}{Whether to show a progress bar. Defaults to \code{TRUE}.}
}
\value{
A tibble with crude and adjusted rate, lower and upper confidence intervals.
}
\description{
Computes direct adjusted rates and confidence intervals.
}
\details{
This functions wraps the \code{epitools} \link[epitools]{ageadjust.direct} function to compute direct adjusted rates and "exact" confidence intervals using \code{tibble} objects with multiple grouping keys.

A tibble (\code{.data}) must be informed containing key variables like year and region code, and population and and events count (e.g. cases) per age group. Check the \code{fleiss_data} for an example.

A tibble (\code{.std}) must be also supplied containing the age groups and population size. By default, this tibble has two variables, named \code{age_group} and \code{pop}.
}
\examples{
standard_pop <- tibble::tibble(
   age_group = c("Under 20", "20-24", "25-29", "30-34", "35-39", "40 and over"),
   population = c(63986.6, 186263.6, 157302.2, 97647.0, 47572.6, 12262.6)
 )
rate_adj_direct(fleiss_data, .std = standard_pop)
}
