% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rolling_ball.R
\name{rolling_ball}
\alias{rolling_ball}
\title{Rolling Ball Baseline Correction}
\usage{
rolling_ball(x, wm, ws = 0)
}
\arguments{
\item{x}{Numeric vector containing the spectrum/signal values}

\item{wm}{Window width (ball radius). Larger values = smoother baseline}

\item{ws}{Smoothing window width (optional)}
}
\value{
A list with three components:
  \describe{
    \item{baseline}{Numeric vector containing the estimated baseline values}
    \item{corrected}{Numeric vector containing the baseline-corrected signal (original - baseline)}
    \item{original}{Numeric vector containing the original input signal}
  }
}
\description{
Implements the rolling ball baseline correction method
}
\examples{
# Example with simulated data
x <- seq(1, 100, by = 1)
y <- sin(x/10) + 0.1*x + rnorm(100, 0, 0.1)
result <- rolling_ball(y, wm = 10)
plot(x, y, type = "l", col = "blue", main = "Rolling Ball Correction")
lines(x, result$baseline, col = "red", lwd = 2)
lines(x, result$corrected, col = "green")
legend("topright", c("Original", "Baseline", "Corrected"),
       col = c("blue", "red", "green"), lty = 1)
}
