% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spec_filter.R
\name{spec_filter}
\alias{spec_filter}
\title{Filter spectral data by wavenumber range}
\usage{
spec_filter(.data, wn_min = NULL, wn_max = NULL)
}
\arguments{
\item{.data}{A data frame containing spectral data.}

\item{wn_min}{Optional numeric value. Minimum wavenumber value to keep.}

\item{wn_max}{Optional numeric value. Maximum wavenumber value to keep.}
}
\value{
A filtered data frame based on the wavenumber column.
}
\description{
This function filters the spectral dataset based on a specified wavenumber (`wn`) range.
It requires the wavenumber column to be previously set using [set_spec_wn()].
If `wn_min` and/or `wn_max` are provided, the data will be filtered accordingly.
If neither is provided, the original dataset is returned unchanged.
}
\examples{
set_spec_wn("Wavenumber")
spec_filter(CoHAspec, wn_min = 500, wn_max = 1800)

}
