% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rowwise.R
\name{rowwise}
\alias{rowwise}
\title{Convert to a rowwise tidytable}
\usage{
rowwise(.df)
}
\arguments{
\item{.df}{A data.frame or data.table}
}
\description{
Convert to a rowwise tidytable.
}
\examples{
df <- tidytable(x = 1:3, y = 1:3 * 2, z = 1:3 * 3)

# Compute the mean of x, y, z in each row
df \%>\%
  rowwise() \%>\%
  mutate(row_mean = mean(c(x, y, z)))

# Use c_across() to more easily select many variables
df \%>\%
  rowwise() \%>\%
  mutate(row_mean = mean(c_across(x:z))) \%>\%
  ungroup()
}
