% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/time.R
\name{interpolate_stop_times}
\alias{interpolate_stop_times}
\title{Interpolate missing stop_times linearly}
\usage{
interpolate_stop_times(x, use_shape_dist = TRUE)
}
\arguments{
\item{x}{tidygtfs object or stop_times table}

\item{use_shape_dist}{If TRUE, use \code{shape_dist_traveled} column from the shapes table for
time interpolation (if that column is available). If FALSE or
\code{shape_dist_traveled} is missing, times are interpolated equally
between stops.}
}
\value{
tidygtfs or stop_times with interpolated arrival and departure times
}
\description{
Interpolate missing stop_times linearly
}
\examples{
\dontrun{
data(gtfs_duke)
print(gtfs_duke$stop_times[1:5, 1:5])

gtfs_duke_2 = interpolate_stop_times(gtfs_duke)
print(gtfs_duke_2$stop_times[1:5, 1:5])

gtfs_duke_3 = interpolate_stop_times(gtfs_duke, FALSE)
print(gtfs_duke_3$stop_times[1:5, 1:5])
}
}
