% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transportation.R
\name{address_ranges}
\alias{address_ranges}
\title{Download an address range features shapefile into R}
\usage{
address_ranges(state, county, year = NULL, ...)
}
\arguments{
\item{state}{The two-digit FIPS code of the state of the county you'd like
to download the roads for. Can also be state name or abbreviation
(case-insensitive).}

\item{county}{The three-digit FIPS code of the county you'd like the roads for.
Can also be a county name.}

\item{year}{the data year; defaults to 2024}

\item{...}{arguments to be passed to internal function \code{load_tiger}, which is not exported. See Additional Arguments.}
}
\description{
Download an address range features shapefile into R
}
\section{Additional Arguments}{

Additional arguments that can be passed in \code{...} are:
\itemize{
\item \code{class} Desired class of return object: \code{"sf"} (the default) or \code{"sp"}.  sp classes should be considered deprecated as of tigris version 2.0, but legacy support is still available.
\item \code{progress_bar} If set to \code{FALSE}, do not display download progress bar (helpful for R Markdown documents). Defaults to \code{TRUE}.
\item \code{keep_zipped_shapefile} If set to \code{TRUE}, do not delete zipped shapefile (stored in temporary directory or \code{TIGRIS_CACHE_DIR}
depending on the configuration of global option \code{"tigris_use_cache"}). Defaults to \code{FALSE}.
\item \code{refresh} Whether to re-download cached shapefiles (\code{TRUE} or \code{FALSE}) . The default is either \code{FALSE} or the value of global
option \code{"tigris_refresh"} if it is set. Specifying this argument will override the behavior set in \code{"tigris_refresh"} global option.
\item \code{filter_by} Geometry used to filter the output returned by the function.  Can be an sf object, an object of class \code{bbox}, or a length-4 vector of format \code{c(xmin, ymin, xmax, ymax)} that can be converted to a bbox. Geometries that intersect the input to \code{filter_by} will be returned.
\item \code{protocol} Character string specifying the protocol to use for downloading files. Options are "ftp" or "http" (default). If "ftp", the URL will be modified to use FTP instead of HTTPS.
\item \code{timeout} Integer specifying the timeout in seconds for download operations if protocol is "ftp". Defaults to 1800 (30 minutes) to handle large files.
}
}

\seealso{
\url{https://www2.census.gov/geo/pdfs/maps-data/data/tiger/tgrshp2020/TGRSHP2020_TechDoc.pdf}

Other transportation functions: 
\code{\link{primary_roads}()},
\code{\link{primary_secondary_roads}()},
\code{\link{rails}()},
\code{\link{roads}()}
}
\concept{transportation functions}
