% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bi_vol.R
\name{bi_vol}
\alias{bi_vol}
\title{Estimate the total or partial volume of the tree, based on a fitted Bi (2000) taper function.}
\usage{
bi_vol(dbh, h, coef, hi, h0)
}
\arguments{
\item{dbh}{tree diameter at breast height, in centimeters.}

\item{h}{total tree height, in meters.}

\item{coef}{numerical vector containing seven coefficients of the Bi taper equation.}

\item{hi}{final height of the tree section whose volume will be calculated, in meters. Default is the total tree height (h).}

\item{h0}{initial height of the tree section whose volume will be calculated, in meters. Default is 0 (ground height).}
}
\value{
a numeric value indicating the total or partial volume of the tree.
}
\description{
Estimates the total or partial volume of the tree from the diameter at breast height, total height, initial section height, final section height and coefficients of the Bi (2000) taper equation.
}
\details{
the Bi (2000) variable-form taper function is represented mathematically by the following expression

di ~ dbh * (log(sin((pi/2) * (hi/h)))/(log(sin((pi/2) * (1.3/h)))))^(b0 + b1 * sin((pi/2) * (hi/h)) + b2 * cos((3 * pi/2) * (hi/h)) + b3 * (sin((pi/2) * (hi/h))/(hi/h)) + b4 * dbh + b5 * (hi/h) * dbh^0.5 + b6 * (hi/h) * h^0.5)
}
\examples{

library(dplyr)
library(minpack.lm)
library(timbeR)

tree_scaling <- tree_scaling \%>\%
mutate(did = di/dbh,
       hih = hi/h)

bi <-  nlsLM(di ~ taper_bi(dbh, h, hih, b0, b1, b2, b3, b4, b5, b6),
data=tree_scaling,
start=list(b0=1.8,b1=-0.2,b2=-0.04,b3=-0.9,b4=-0.0006,b5=0.07,b6=-.14))

coef_bi <- coef(bi)

dbh <- 25
h <- 20

bi_vol(dbh, h, coef_bi)

hi = 15
h0 = .2

bi_vol(dbh, h, coef_bi, hi, h0)

}
