% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.R
\name{print.TwoSampleAalenJohansen}
\alias{print.TwoSampleAalenJohansen}
\title{Print function for object of class 'TwoSampleAalenJohansen'}
\usage{
\method{print}{TwoSampleAalenJohansen}(x, digits = 4, what = "both", method = NULL, absRisk = TRUE, ...)
}
\arguments{
\item{x}{an object of class 'TwoSampleAalenJohansen'}

\item{digits}{number of digits to print the results}

\item{what}{either "RR", "Diff" or "both" (default), depending on whether we want to print the results for the risk ratio (RR), the risk difference (Diff) or both.}

\item{method}{either "EL", "Wald" or "both", depending on whether we want to print the results obtained when using empirical likelihood inference (EL), Wald-type inference (Wald) or both. Default is 'NULL', which means that 'method' inherits the value of the corresponding control parameter used when creating the object 'x'.}

\item{absRisk}{Default is TRUE and this should not be changed.}

\item{...}{Not used}
}
\value{
no return value, called for printing only.
}
\description{
Print function for object of class 'TwoSampleAalenJohansen'
}
\examples{
## A simple example for Wald-type inference, using simulated data.
## It illustrates the possible inconsistency of Wald-type inference, in
## terms of statistical significance, when inference is based on the risk
## ratio and on the risk difference. This inconsistency cannot exist
## using an empirical likelihood approach.

ResSimA100 <- TwoSampleAalenJohansen(time=SimA100$time,
                                     cause=SimA100$status,
                                     group=SimA100$group,
                                     t=1,
                                     contr=list(method="Wald"))
print(ResSimA100, digits=3, what="Diff")
print(ResSimA100, digits=3, what="RR")

\dontshow{if (FALSE) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
## Same example data, but now analyzed with and empirical likelihood approach. It
## takes approx 20 seconds to run.

ResSimA100 <- TwoSampleAalenJohansen(time=SimA100$time,
                                     cause=SimA100$status,
                                     group=SimA100$group,
                                     t=1)
print(ResSimA100, digits=3, what="Diff",  method="EL")
\dontshow{\}) # examplesIf}
}
\author{
Paul Blanche
}
