% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ttest.R
\name{test_ref}
\alias{test_ref}
\title{Test difference between correlation coefficient estimates and a value of reference}
\usage{
test_ref(
  tcor_obj,
  t = tcor_obj$t,
  r_ref = 0,
  test = c("student", "chi2"),
  p.adjust.methods = c("none", "bonferroni", "holm", "hochberg", "hommel", "BH", "BY",
    "fdr")
)
}
\arguments{
\item{tcor_obj}{the output of a call to \code{\link[=tcor]{tcor()}} with \code{CI = TRUE}.}

\item{t}{a vector of time point(s) used by the test (by default, all time points are considered).}

\item{r_ref}{a scalar indicating the reference value for the correlation coefficient to be used in the test (default = \code{0}).}

\item{test}{a character string indicating which test to use ("student", the default; or "chi2").}

\item{p.adjust.methods}{a character string indicating the method used to adjust p-values for multiple testing (see \code{\link[=p.adjust]{p.adjust()}}; default = "none").}
}
\value{
a data.frame with the result of the test, including the effect size (\code{delta_r = r[t] - r_ref}).
}
\description{
This function tests whether smoothed correlation values are equal (H0) or not to a reference value (default = \code{0}).
The test is not described in Choi & Shin, 2021, but it is based on the idea behind \code{\link[=test_equality]{test_equality()}}.
}
\details{
Two different test statistics can be used, one is asymptotically Student-t distributed under H0 and one is chi-square distributed.
In practice, it seems to give very similar results.
}
\examples{
## Comparison of all correlation values to reference of 0.5

res <- with(stockprice, tcor(x = SP500, y = FTSE100, t = DateID, h = 300, CI = TRUE))
ref <- 0.5
test_against_ref <- test_ref(res, r_ref = ref)
head(test_against_ref)


## Plot to illustrate the correspondance with confidence intervals

plot(res$r ~ res$t, type = "l", ylim = c(0, 1), col = NULL)
abline(v = test_against_ref$t[test_against_ref$p > 0.05], col = "lightgreen")
abline(v = test_against_ref$t[test_against_ref$p < 0.05], col = "red")
points(res$r ~ res$t, type = "l")
points(res$upr ~ res$t, type = "l", lty = 2)
points(res$lwr ~ res$t, type = "l", lty = 2)
abline(h = ref, col = "blue")


## Test correlation of 0 a specific time points (using index or dates)

test_ref(res, t = c(100, 150))
test_ref(res, t = c("2000-08-18", "2000-10-27"))

}
\seealso{
\code{\link[=test_equality]{test_equality()}}, \code{\link[=tcor]{tcor()}}
}
