% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_sem_ram.R
\name{make_sem_ram}
\alias{make_sem_ram}
\title{Make a RAM (Reticular Action Model) from a SEM (structural equation model)}
\usage{
make_sem_ram(sem, variables, quiet = FALSE, covs = variables)
}
\arguments{
\item{sem}{structural equation model structure, passed to either \code{\link[sem]{specifyModel}}
or \code{\link[sem]{specifyEquations}} and then parsed to control
the set of path coefficients and variance-covariance parameters}

\item{variables}{A character vector listing the set of variables}

\item{quiet}{if \code{FALSE}, the default, then the number of input lines is reported and
    a message is printed suggesting that \code{specifyEquations} or \code{cfa} be used.}

\item{covs}{optional: a character vector of one or more elements, with each element
  	giving a string of variable names, separated by commas. Variances and covariances
  	among all variables in each such string are added to the model. For confirmatory
  	factor analysis models specified via \code{cfa}, \code{covs} defaults to all of
  	the factors in the model, thus specifying all variances and covariances among these factors.
  	\emph{Warning}: \code{covs="x1, x2"} and \code{covs=c("x1", "x2")} are \emph{not}
  	equivalent: \code{covs="x1, x2"} specifies the variance of \code{x1}, the variance
  	of \code{x2}, \emph{and} their covariance, while \code{covs=c("x1", "x2")} specifies
  	the variance of \code{x1} and the variance of \code{x2} \emph{but not} their covariance.}
}
\value{
An S3-class \code{"sem_ram"} containing:
\describe{
\item{\code{model}}{Output from \code{\link[sem]{specifyEquations}} or \code{\link[sem]{specifyModel}}
that defines paths and parameters}
\item{\code{ram}}{reticular action module (RAM) describing dependencies}
}
}
\description{
\code{make_sem_ram} converts SEM arrow notation to \code{ram} describing SEM parameters
}
