% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runTestDir.R
\name{runTestFile}
\alias{runTestFile}
\title{Internal wrapper arround tinytest::run_test_file}
\usage{
runTestFile(file, ...)
}
\arguments{
\item{file}{\code{character(1)} test file to run.}

\item{...}{arguments passed on to \code{\link[tinytest:run_test_file]{tinytest::run_test_file()}}}
}
\value{
a \code{tinytests2JUnit} object (being a subclass of \code{tinytest} object).
}
\description{
Internal wrapper arround \code{\link[tinytest:run_test_file]{tinytest::run_test_file()}} that records the test duration and
catches uncaught errors and logs the stacktrace of where the error occured.
}
\details{
The response is a subclass of the \code{tinytests} object called: \code{tinytests2Junit}
object which captures additional info for the reporting to JUnit:
\itemize{
\item Duration to run the file.
\item Timestamp when the test was run.
\item hostname of the computer where it was ran on.
}

The caught error is turned into a subclass uncaught-error of tinytest. This is implementation
detail and only to be understood by constructJUnitTag.

If an error occured it is captured and \code{uncaught-error} object (subclass of \code{tinytest}) is
returned in the \code{tinytests} object.
This tinytest object represents a "failed" tests that will get reported as an Error in the
JUnit. Various aspects of the error are also captured like the the stacktrace.
}
