% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/testPackage.R
\name{testPackage}
\alias{testPackage}
\title{Test an R package and report the results in JUnit}
\usage{
testPackage(
  pkgname,
  file = stdout(),
  errorOnFailure = TRUE,
  testdir = "tinytest",
  lib.loc = NULL,
  at_home = FALSE,
  ncpu = NULL,
  ...
)
}
\arguments{
\item{pkgname}{\code{character(1)}. Name of the package to tests.}

\item{file}{\code{character(1) | connection}: Full file path or connection object to write the
JUnit xml content to. By default \code{stdout()} connection is used.
\strong{Warning} if the file already exist it will be overwritten!}

\item{errorOnFailure}{\code{logical(1)} Should an error be raised (after writing the JUnit) when a
at least one test failed? By default TRUE. This is done as a
convenience to have the CI fail at the test stage on failure.}

\item{testdir}{\code{character(1)} testing directory of the package. See ?\code{\link[tinytest:test_package]{tinytest::test_package()}}
for more details.}

\item{lib.loc}{\code{character(1) | NULL} Library location where the package is installed.
By default: \code{NULL} meaning the package is searched on the standard .libPaths().}

\item{at_home}{\code{logical(1)} should local test be run? By default FALSE as we want to as closely
mimic the environement of how tests would get ran in CRAN.
See for more details \code{\link[tinytest:test_package]{tinytest::test_package()}}.}

\item{ncpu}{\verb{postive integer(1) | clutser} Either an integer specifying the amount of cpu's
to parralize the testing over or a \code{cluster} object to run the tests in.}

\item{...}{Extra arguments passed on to \code{\link[=runTestDir]{runTestDir()}}}
}
\value{
If \code{errorOnFailure} = FALSE, a \code{tinytests2JUnit} object (a subclass of \code{tinytests}
object that captures more info for export to JUnit). Else, an error is raised if at least
on failure occurs. Meant as convenience to automatically stop the CI build.
}
\description{
Run all tests of a package and report the results as JUnit xml. This function
can be seen as a drop in replacement for \code{\link[tinytest:test_package]{tinytest::test_package()}} but with a
key difference that uncaught errors will be catched and reported JUnit!
This function is intended to be used in a test stage of a CI build.
}
\details{
\code{\link[=testPackage]{testPackage()}} is meant as a CI-friendly alternative to the native \code{\link[tinytest:test_package]{tinytest::test_package()}}.
Next to directly reporting the tests results in a JUnit xml format, it also catches errors that
are raised in the tests files and reports them as "error" in the JUnit.

\code{\link[tinytest:test_package]{tinytest::test_package()}} would have let the error bubble up, stop the testing
process and not report any failures from other test files. One is then also forced
to look into the logs of the CI to see what the error was. \code{\link[=testPackage]{testPackage()}} presents you that
error in the JUnit with a stacktrace. Next to all the test results of the other files that
ran without a problem.

If you prefer the behaviour from \code{\link[tinytest:test_package]{tinytest::test_package()}}, you can still use it in
combination with \code{\link[=writeJUnit]{writeJUnit()}} if all tests results pass.

Just like \code{\link[tinytest:test_package]{tinytest::test_package()}} an error is raised if at least one failure occured during
testing. Obviously catched errors are also seen as failures. This error is raised
\strong{after} the test results have been written away to the file, such that your CI can still pick
it up and report the failure.
The error raising is done as a convenience to stop the CI from continue if test-failure occured.
You can opt-out of this behaviour by setting the \code{errorOnFailure} parameter to FALSE. Then a
case \code{tinytests2JUnit} object is returned (a sub-class of \code{tinytests} object containing addition
info for the JUnit).
Caught errors are also captured in this object as \code{tinytest}-objects. They
actually have a special sub-class but this is considered an internal implemenation detail.

\code{\link[=testPackage]{testPackage()}} is NOT meant to be called from within your \code{tests/tinytests.R} file! Tests
invoked by R CMD Check or on CRAN should still make use of \code{\link[tinytest:test_package]{tinytest::test_package()}}.
This function is only meant to be called from within a testing step in your CI to
report the test results in an JUnit xml format.
}
\section{Side-effects}{

Side effects are registered as 'passed' tests in the JUnit output and have been given a status
"SIDE-EFFECT". The call and diff is also returned in the standard-output of the testcase tag.

They are not considred failures and would thus not stop a pipeline.
}

\section{tinytests to JUnit}{


To comply the the JUnit specification the tests results are adapted as follows:
\itemize{
\item A single test run \code{tinytests} is mapped to a \verb{<testsuites>} tag.
\item All \code{tinytest} results from a single file are mapped to a single \verb{<testsuite>} tag.
\itemize{
\item The name of the testsuite is equal to the test file name (without the file suffix)
}
\item An individual \code{tinytest} object (eg. a single \verb{except_*} exception test) is mapped to a
\verb{<testcase>} tag.
\itemize{
\item The name of the testcase is equal to the fileName + Line specification of where the expect
statement is performed + the info.
}
}

For reference: \url{https://llg.cubic.org/docs/junit/}
}

\examples{
tmpFile <- tempfile(fileext = ".xml")
testPackage("tinytest", file = tmpFile, verbose = 0)
}
\seealso{
\code{\link[=runTestDir]{runTestDir()}} and \code{\link[tinytest:test_package]{tinytest::test_package()}}.
}
