% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bcm-class.R
\docType{class}
\name{bcm-class}
\alias{bcm-class}
\title{Bayesian Clustering Model (bcm) S4 class.}
\value{
An object of class bcm.
}
\description{
An S4 class to store the results of the Gibbs sampler.
}
\section{Slots}{

\describe{
\item{\code{n}}{Positive integer: the sample size (i.e., the number of subjects).}

\item{\code{burn}}{Non-negative integer: the number of burn-in iterations in the Gibbs sampler.}

\item{\code{samples}}{Positive integer: the number of sampling iterations in the Gibbs sampler.}

\item{\code{posterior_assignments}}{List of vectors of positive integers: a list of vectors of cluster assignments (i.e., positive integers) for each sampling iteration in the Gibbs sampler.}

\item{\code{posterior_similarity_matrix}}{Matrix: a matrix where the (i,j)th element is the posterior probability that subject i and subject j belong to the same cluster.}

\item{\code{posterior_number_of_clusters}}{Vector of positive integers: each vector element is the number of clusters after posterior sampling for each sampling iteration in the Gibbs sampler.}

\item{\code{prior_name}}{Character: the name of the prior used.}

\item{\code{likelihood_name}}{Character: the name of the likelihood used.}
}}

