% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggplot_number_of_clusters_hist.R
\name{ggplot_number_of_clusters_hist}
\alias{ggplot_number_of_clusters_hist}
\title{Plot the posterior distribution of the number of clusters.}
\usage{
ggplot_number_of_clusters_hist(.posterior_number_of_clusters)
}
\arguments{
\item{.posterior_number_of_clusters}{Vector of positive integers: each integer corresponds to the
number of clusters after posterior sampling for a given sampling iteration in the Gibbs sampler.}
}
\value{
ggplot2 geom_bar plot: a plot of the distribution of the posterior number of clusters
computed after each sampling iteration in the Gibbs sampler.
}
\description{
A function that produces a ggplot bar chart (i.e., geom_bar) that corresponds
to the posterior number of clusters. The vertical axis is normalized so that it displays
the posterior probability.
}
\examples{
# Import the tip library
library(tip)

# Generate a vector of positive integers
# Example: the posterior number of clusters computed after posterior
# sampling in each sampling iteration of the Gibbs sampler.
num_clusters <- c(1,2,2,2,2,3,3,1,2,3,3,3,1,3)

# Generate the plot of the posterior number of clusters versus the
# sampling iteration number in the Gibbs sampler.
ggplot_number_of_clusters_hist(.posterior_number_of_clusters = num_clusters)
}
